/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class LayeredPaneDemo
extends JPanel
implements ActionListener,
MouseMotionListener {
    private String[] layerStrings = new String[]{"Yellow (0)", "Magenta (1)", "Cyan (2)", "Red (3)", "Green (4)"};
    private Color[] layerColors = new Color[]{Color.yellow, Color.magenta, Color.cyan, Color.red, Color.green};
    private JLayeredPane layeredPane;
    private JLabel dukeLabel;
    private JCheckBox onTop;
    private JComboBox layerList;
    private static String ON_TOP_COMMAND = "ontop";
    private static String LAYER_COMMAND = "layer";
    private static final int XFUDGE = 40;
    private static final int YFUDGE = 57;
    static /* synthetic */ Class class$LayeredPaneDemo;

    public LayeredPaneDemo() {
        this.setLayout(new BoxLayout(this, 3));
        ImageIcon imageIcon = LayeredPaneDemo.createImageIcon("images/dukeWaveRed.gif");
        this.layeredPane = new JLayeredPane();
        this.layeredPane.setPreferredSize(new Dimension(300, 310));
        this.layeredPane.setBorder(BorderFactory.createTitledBorder("Move the Mouse to Move Duke"));
        this.layeredPane.addMouseMotionListener(this);
        Point point = new Point(10, 20);
        int n = 35;
        int n2 = 0;
        while (n2 < this.layerStrings.length) {
            JLabel jLabel = this.createColoredLabel(this.layerStrings[n2], this.layerColors[n2], point);
            this.layeredPane.add((Component)jLabel, new Integer(n2));
            point.x += n;
            point.y += n;
            ++n2;
        }
        this.dukeLabel = new JLabel(imageIcon);
        if (imageIcon != null) {
            this.dukeLabel.setBounds(15, 225, imageIcon.getIconWidth(), imageIcon.getIconHeight());
        } else {
            System.err.println("Duke icon not found; using black square instead.");
            this.dukeLabel.setBounds(15, 225, 30, 30);
            this.dukeLabel.setOpaque(true);
            this.dukeLabel.setBackground(Color.BLACK);
        }
        this.layeredPane.add(this.dukeLabel, new Integer(2), 0);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(this.createControlPanel());
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(this.layeredPane);
    }

    protected static ImageIcon createImageIcon(String string) {
        URL uRL = (class$LayeredPaneDemo == null ? (class$LayeredPaneDemo = LayeredPaneDemo.class$("LayeredPaneDemo")) : class$LayeredPaneDemo).getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    private JLabel createColoredLabel(String string, Color color, Point point) {
        JLabel jLabel = new JLabel(string);
        jLabel.setVerticalAlignment(1);
        jLabel.setHorizontalAlignment(0);
        jLabel.setOpaque(true);
        jLabel.setBackground(color);
        jLabel.setForeground(Color.black);
        jLabel.setBorder(BorderFactory.createLineBorder(Color.black));
        jLabel.setBounds(point.x, point.y, 140, 140);
        return jLabel;
    }

    private JPanel createControlPanel() {
        this.onTop = new JCheckBox("Top Position in Layer");
        this.onTop.setSelected(true);
        this.onTop.setActionCommand(ON_TOP_COMMAND);
        this.onTop.addActionListener(this);
        this.layerList = new JComboBox<String>(this.layerStrings);
        this.layerList.setSelectedIndex(2);
        this.layerList.setActionCommand(LAYER_COMMAND);
        this.layerList.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.layerList);
        jPanel.add(this.onTop);
        jPanel.setBorder(BorderFactory.createTitledBorder("Choose Duke's Layer and Position"));
        return jPanel;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.dukeLabel.setLocation(mouseEvent.getX() - 40, mouseEvent.getY() - 57);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (ON_TOP_COMMAND.equals(string)) {
            if (this.onTop.isSelected()) {
                this.layeredPane.moveToFront(this.dukeLabel);
            } else {
                this.layeredPane.moveToBack(this.dukeLabel);
            }
        } else if (LAYER_COMMAND.equals(string)) {
            int n = this.onTop.isSelected() ? 0 : 1;
            this.layeredPane.setLayer(this.dukeLabel, this.layerList.getSelectedIndex(), n);
        }
    }

    public static void main(String[] stringArray) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("LayeredPaneDemo");
        jFrame.setDefaultCloseOperation(3);
        LayeredPaneDemo layeredPaneDemo = new LayeredPaneDemo();
        layeredPaneDemo.setOpaque(true);
        jFrame.setContentPane(layeredPaneDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

