/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Converter {
    ConversionPanel metricPanel;
    ConversionPanel usaPanel;
    Unit[] metricDistances = new Unit[3];
    Unit[] usaDistances = new Unit[4];
    static final boolean MULTICOLORED = false;
    static final String LOOKANDFEEL = null;
    ConverterRangeModel dataModel = new ConverterRangeModel();
    JPanel mainPane;

    public Converter() {
        this.metricDistances[0] = new Unit("Centimeters", 0.01);
        this.metricDistances[1] = new Unit("Meters", 1.0);
        this.metricDistances[2] = new Unit("Kilometers", 1000.0);
        this.metricPanel = new ConversionPanel(this, "Metric System", this.metricDistances, this.dataModel);
        this.usaDistances[0] = new Unit("Inches", 0.0254);
        this.usaDistances[1] = new Unit("Feet", 0.305);
        this.usaDistances[2] = new Unit("Yards", 0.914);
        this.usaDistances[3] = new Unit("Miles", 1613.0);
        this.usaPanel = new ConversionPanel(this, "U.S. System", this.usaDistances, new FollowerRangeModel(this.dataModel));
        this.mainPane = new JPanel();
        this.mainPane.setLayout(new BoxLayout(this.mainPane, 3));
        this.mainPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.mainPane.add(Box.createRigidArea(new Dimension(0, 5)));
        this.mainPane.add(this.metricPanel);
        this.mainPane.add(Box.createRigidArea(new Dimension(0, 5)));
        this.mainPane.add(this.usaPanel);
        this.mainPane.add(Box.createGlue());
        this.resetMaxValues(true);
    }

    public void resetMaxValues(boolean bl) {
        double d = this.metricPanel.getMultiplier();
        double d2 = this.usaPanel.getMultiplier();
        int n = 10000;
        if (d > d2) {
            n = (int)(10000.0 * (d2 / d));
        }
        this.dataModel.setMaximum(n);
        if (bl) {
            this.dataModel.setDoubleValue(n);
        }
    }

    private static void initLookAndFeel() {
        block12: {
            String string = null;
            if (LOOKANDFEEL == null) break block12;
            if (LOOKANDFEEL.equals("Metal")) {
                string = UIManager.getCrossPlatformLookAndFeelClassName();
            } else if (LOOKANDFEEL.equals("System")) {
                string = UIManager.getSystemLookAndFeelClassName();
            } else if (LOOKANDFEEL.equals("Motif")) {
                string = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            } else if (LOOKANDFEEL.equals("GTK+")) {
                string = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
            } else {
                System.err.println("Unexpected value of LOOKANDFEEL specified: " + LOOKANDFEEL);
                string = UIManager.getCrossPlatformLookAndFeelClassName();
            }
            try {
                UIManager.setLookAndFeel(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Couldn't find class for specified look and feel:" + string);
                System.err.println("Did you include the L&F library in the class path?");
                System.err.println("Using the default look and feel.");
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                System.err.println("Can't use the specified look and feel (" + string + ") on this platform.");
                System.err.println("Using the default look and feel.");
            }
            catch (Exception exception) {
                System.err.println("Couldn't get specified look and feel (" + string + "), for some reason.");
                System.err.println("Using the default look and feel.");
                exception.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        Converter.initLookAndFeel();
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("Converter");
        jFrame.setDefaultCloseOperation(3);
        Converter converter = new Converter();
        converter.mainPane.setOpaque(true);
        jFrame.setContentPane(converter.mainPane);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

