/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;

public class IconDemoApplet
extends JApplet
implements ActionListener {
    Vector pictures;
    JButton previousButton;
    JButton nextButton;
    JLabel photographLabel;
    JLabel captionLabel;
    JLabel numberLabel;
    int current;
    int widthOfWidest;
    int heightOfTallest;
    String imagedir;

    public void init() {
        this.pictures = this.parseParameters();
        if (this.pictures.size() == 0) {
            this.captionLabel = new JLabel("No images listed in applet tag.");
            this.captionLabel.setHorizontalAlignment(0);
            this.getContentPane().add(this.captionLabel);
            return;
        }
        this.numberLabel = new JLabel("Picture " + (this.current + 1) + " of " + this.pictures.size());
        this.numberLabel.setHorizontalAlignment(2);
        this.numberLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        Photo photo = (Photo)this.pictures.firstElement();
        this.captionLabel = new JLabel(photo.caption);
        this.captionLabel.setHorizontalAlignment(0);
        this.captionLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.photographLabel = new JLabel("Loading first image...");
        this.photographLabel.setHorizontalAlignment(0);
        this.photographLabel.setVerticalAlignment(0);
        this.photographLabel.setVerticalTextPosition(0);
        this.photographLabel.setHorizontalTextPosition(0);
        this.photographLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.photographLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0), this.photographLabel.getBorder()));
        Insets insets = this.photographLabel.getInsets();
        this.photographLabel.setPreferredSize(new Dimension(this.widthOfWidest + insets.left + insets.right, this.heightOfTallest + insets.bottom + insets.top));
        ImageIcon imageIcon = new ImageIcon(this.getURL(String.valueOf(this.imagedir) + "right.gif"));
        ImageIcon imageIcon2 = new ImageIcon(this.getURL(String.valueOf(this.imagedir) + "dimmedRight.gif"));
        ImageIcon imageIcon3 = new ImageIcon(this.getURL(String.valueOf(this.imagedir) + "left.gif"));
        ImageIcon imageIcon4 = new ImageIcon(this.getURL(String.valueOf(this.imagedir) + "dimmedLeft.gif"));
        this.previousButton = new JButton("Previous Picture", imageIcon3);
        this.previousButton.setDisabledIcon(imageIcon4);
        this.previousButton.setVerticalTextPosition(0);
        this.previousButton.setHorizontalTextPosition(4);
        this.previousButton.setMnemonic(80);
        this.previousButton.setActionCommand("previous");
        this.previousButton.addActionListener(this);
        this.previousButton.setEnabled(false);
        this.nextButton = new JButton("Next Picture", imageIcon);
        this.nextButton.setDisabledIcon(imageIcon2);
        this.nextButton.setVerticalTextPosition(0);
        this.nextButton.setHorizontalTextPosition(2);
        this.nextButton.setMnemonic(78);
        this.nextButton.setActionCommand("next");
        this.nextButton.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Container container = this.getContentPane();
        container.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.numberLabel, gridBagConstraints);
        container.add(this.numberLabel);
        gridBagLayout.setConstraints(this.captionLabel, gridBagConstraints);
        container.add(this.captionLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.photographLabel, gridBagConstraints);
        container.add(this.photographLabel);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.previousButton, gridBagConstraints);
        container.add(this.previousButton);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.nextButton, gridBagConstraints);
        container.add(this.nextButton);
        this.loadImage(String.valueOf(this.imagedir) + photo.filename, this.current);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.photographLabel.setIcon(null);
        this.photographLabel.setText("Loading image...");
        if (actionEvent.getActionCommand().equals("next")) {
            ++this.current;
            if (!this.previousButton.isEnabled()) {
                this.previousButton.setEnabled(true);
            }
            if (this.current == this.pictures.size() - 1) {
                this.nextButton.setEnabled(false);
            }
        } else {
            --this.current;
            if (!this.nextButton.isEnabled()) {
                this.nextButton.setEnabled(true);
            }
            if (this.current == 0) {
                this.previousButton.setEnabled(false);
            }
        }
        Photo photo = (Photo)this.pictures.elementAt(this.current);
        this.captionLabel.setText(photo.caption);
        this.numberLabel.setText("Picture " + (this.current + 1) + " of " + this.pictures.size());
        ImageIcon imageIcon = photo.getIcon();
        if (imageIcon == null) {
            this.loadImage(String.valueOf(this.imagedir) + photo.filename, this.current);
            return;
        }
        this.updatePhotograph(this.current, photo);
    }

    private void updatePhotograph(int n, Photo photo) {
        ImageIcon imageIcon = photo.getIcon();
        this.photographLabel.setToolTipText(String.valueOf(photo.filename) + ": " + imageIcon.getIconWidth() + " X " + imageIcon.getIconHeight());
        this.photographLabel.setIcon(imageIcon);
        this.photographLabel.setText("");
    }

    private void loadImage(String string, int n) {
        1 var3_3 = new 1(string, n, this);
        var3_3.start();
    }

    protected URL getURL(String string) {
        URL uRL = this.getCodeBase();
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Couldn't create image: badly specified URL");
            return null;
        }
        return uRL2;
    }

    protected Vector parseParameters() {
        String string;
        Vector<Photo> vector = new Vector<Photo>(10);
        int n = 0;
        String string2 = "IMAGE" + n;
        while ((string = this.getParameter(string2)) != null) {
            Photo photo = new Photo(string, this.getCaption(n), this.getWidth(n), this.getHeight(n));
            vector.addElement(photo);
            string2 = "IMAGE" + ++n;
        }
        this.imagedir = this.getParameter("IMAGEDIR");
        if (this.imagedir != null) {
            this.imagedir = String.valueOf(this.imagedir) + "/";
        }
        return vector;
    }

    protected String getCaption(int n) {
        return this.getParameter("CAPTION" + n);
    }

    protected int getWidth(int n) {
        int n2 = 0;
        String string = this.getParameter("WIDTH" + n);
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
        } else {
            n2 = 0;
        }
        if (n2 > this.widthOfWidest) {
            this.widthOfWidest = n2;
        }
        return n2;
    }

    protected int getHeight(int n) {
        int n2 = 0;
        String string = this.getParameter("HEIGHT" + n);
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
        } else {
            n2 = 0;
        }
        if (n2 > this.heightOfTallest) {
            this.heightOfTallest = n2;
        }
        return n2;
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"IMAGEDIR", "string", "directory containing image files"}, {"IMAGEN", "string", "filename"}, {"CAPTIONN", "string", "caption"}, {"WIDTHN", "integer", "width of image"}, {"HEIGHTN", "integer", "height of image"}};
        return stringArray;
    }

    private static final class 1
    extends SwingWorker {
        private final /* synthetic */ int val$index;
        private final /* synthetic */ IconDemoApplet this$0;
        private final /* synthetic */ String val$imagePath;
        ImageIcon icon;

        public Object construct() {
            this.icon = new ImageIcon(this.this$0.getURL(this.val$imagePath));
            return this.icon;
        }

        public void finished() {
            Photo photo = (Photo)this.this$0.pictures.elementAt(this.val$index);
            photo.setIcon(this.icon);
            if (this.val$index == this.this$0.current) {
                this.this$0.updatePhotograph(this.val$index, photo);
            }
        }

        /* synthetic */ 1(String string, int n, IconDemoApplet iconDemoApplet) {
            this.val$imagePath = string;
            this.val$index = n;
            this.this$0 = iconDemoApplet;
        }
    }
}

