/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class KeyEventDemo
extends JApplet
implements KeyListener,
ActionListener {
    JTextArea displayArea;
    JTextField typingArea;
    static final String newline = "\n";

    public void init() {
        JButton jButton = new JButton("Clear");
        jButton.addActionListener(this);
        this.typingArea = new JTextField(20);
        this.typingArea.addKeyListener(this);
        this.displayArea = new JTextArea();
        this.displayArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.displayArea);
        jScrollPane.setPreferredSize(new Dimension(375, 125));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(true);
        jPanel.add((Component)this.typingArea, "First");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jButton, "Last");
        this.setContentPane(jPanel);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.displayInfo(keyEvent, "KEY TYPED: ");
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.displayInfo(keyEvent, "KEY PRESSED: ");
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.displayInfo(keyEvent, "KEY RELEASED: ");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.displayArea.setText("");
        this.typingArea.setText("");
        this.typingArea.requestFocus();
    }

    protected void displayInfo(KeyEvent keyEvent, String string) {
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        String string2 = Character.isISOControl(c) ? "key character = (an unprintable control character)" : "key character = '" + c + "'";
        String string3 = "key code = " + n + " (" + KeyEvent.getKeyText(n) + ")";
        String string4 = "modifiers = " + n2;
        String string5 = KeyEvent.getKeyModifiersText(n2);
        string4 = string5.length() > 0 ? string4 + " (" + string5 + ")" : string4 + " (no modifiers)";
        this.displayArea.append(string + newline + "    " + string2 + newline + "    " + string3 + newline + "    " + string4 + newline);
    }
}

