/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class DocumentEventDemo
extends JApplet
implements ActionListener {
    JTextField textField;
    JTextArea textArea;
    JTextArea displayArea;

    public void init() {
        JButton jButton = new JButton("Clear");
        jButton.addActionListener(this);
        this.textField = new JTextField(20);
        this.textField.addActionListener(new MyTextActionListener());
        this.textField.getDocument().addDocumentListener(new MyDocumentListener());
        this.textField.getDocument().putProperty("name", "Text Field");
        this.textArea = new JTextArea();
        this.textArea.getDocument().addDocumentListener(new MyDocumentListener());
        this.textArea.getDocument().putProperty("name", "Text Area");
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jScrollPane.setPreferredSize(new Dimension(200, 75));
        this.displayArea = new JTextArea();
        this.displayArea.setEditable(false);
        JScrollPane jScrollPane2 = new JScrollPane(this.displayArea);
        jScrollPane2.setPreferredSize(new Dimension(200, 75));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setOpaque(true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.textField, gridBagConstraints);
        jPanel.add(this.textField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jScrollPane2, gridBagConstraints);
        jPanel.add(jScrollPane2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jPanel.add(jButton);
        this.setContentPane(jPanel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.displayArea.setText("");
        this.textField.requestFocus();
    }

    class MyTextActionListener
    implements ActionListener {
        MyTextActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = DocumentEventDemo.this.textArea.getSelectionStart();
            int n2 = DocumentEventDemo.this.textArea.getSelectionEnd();
            DocumentEventDemo.this.textArea.replaceRange(DocumentEventDemo.this.textField.getText(), n, n2);
            DocumentEventDemo.this.textField.selectAll();
        }
    }

    class MyDocumentListener
    implements DocumentListener {
        final String newline = "\n";

        MyDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateLog(documentEvent, "inserted into");
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateLog(documentEvent, "removed from");
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void updateLog(DocumentEvent documentEvent, String string) {
            Document document = documentEvent.getDocument();
            int n = documentEvent.getLength();
            DocumentEventDemo.this.displayArea.append(n + " character" + (n == 1 ? " " : "s ") + string + " " + document.getProperty("name") + "." + "\n" + "  Text length = " + document.getLength() + "\n");
        }
    }
}

