/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;

public class MovingImageTimer
extends JApplet
implements ActionListener {
    int frameNumber = -1;
    boolean frozen = false;
    Timer timer;
    AnimationPane animationPane;
    static String fgFile = "images/rocketship.gif";
    static String bgFile = "images/starfield.gif";

    public void init() {
        Image image = this.getImage(this.getCodeBase(), bgFile);
        Image image2 = this.getImage(this.getCodeBase(), fgFile);
        this.buildUI(this.getContentPane(), image, image2);
    }

    void buildUI(Container container, Image image, Image image2) {
        int n = 10;
        int n2 = n > 0 ? 1000 / n : 100;
        this.timer = new Timer(n2, this);
        this.timer.setInitialDelay(0);
        this.timer.setCoalesce(true);
        this.animationPane = new AnimationPane(image, image2);
        container.add((Component)this.animationPane, "Center");
        this.animationPane.addMouseListener(new 1());
    }

    public void start() {
        this.startAnimation();
    }

    public void stop() {
        this.stopAnimation();
    }

    public synchronized void startAnimation() {
        if (!this.frozen && !this.timer.isRunning()) {
            this.timer.start();
        }
    }

    public synchronized void stopAnimation() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ++this.frameNumber;
        this.animationPane.repaint();
    }

    public static void main(String[] stringArray) {
        Image image = Toolkit.getDefaultToolkit().getImage(bgFile);
        Image image2 = Toolkit.getDefaultToolkit().getImage(fgFile);
        JFrame jFrame = new JFrame("MovingImageTimer");
        MovingImageTimer movingImageTimer = new MovingImageTimer();
        movingImageTimer.buildUI(jFrame.getContentPane(), image, image2);
        jFrame.addWindowListener(movingImageTimer.new 2());
        ((Component)jFrame).setSize(new Dimension(500, 125));
        ((Component)jFrame).setVisible(true);
        movingImageTimer.startAnimation();
    }

    private final class 1
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (MovingImageTimer.this.frozen) {
                MovingImageTimer.this.frozen = false;
                MovingImageTimer.this.startAnimation();
                return;
            }
            MovingImageTimer.this.frozen = true;
            MovingImageTimer.this.stopAnimation();
        }

        /* synthetic */ 1() {
        }
    }

    class AnimationPane
    extends JPanel {
        Image background;
        Image foreground;

        public AnimationPane(Image image, Image image2) {
            MovingImageTimer.this = MovingImageTimer.this;
            this.background = image;
            this.foreground = image2;
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = this.background.getWidth(this);
            int n4 = this.background.getHeight(this);
            if (n3 > 0 && n4 > 0) {
                graphics.drawImage(this.background, (n - n3) / 2, (n2 - n4) / 2, this);
            }
            n3 = this.foreground.getWidth(this);
            n4 = this.foreground.getHeight(this);
            if (n3 > 0 && n4 > 0) {
                graphics.drawImage(this.foreground, MovingImageTimer.this.frameNumber * 5 % (n3 + n) - n3, (n2 - n4) / 2, this);
            }
        }
    }

    private final class 2
    extends WindowAdapter {
        public void windowIconified(WindowEvent windowEvent) {
            MovingImageTimer.this.stopAnimation();
        }

        public void windowDeiconified(WindowEvent windowEvent) {
            MovingImageTimer.this.startAnimation();
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }

        /* synthetic */ 2() {
        }
    }
}

