/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

class FontPanel
extends JPanel {
    final int maxCharHeight = 17;
    final int minFontSize = 6;
    final int maxFontSize = 14;
    final Color bg = Color.lightGray;
    final Color fg = Color.black;
    Dimension totalSize;
    FontMetrics fontMetrics;
    Font biggestFont = new Font("SansSerif", 0, 14);

    public FontPanel() {
        this.setBackground(this.bg);
        this.setForeground(this.fg);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder()));
    }

    FontMetrics pickFont(Graphics graphics, String string, int n) {
        boolean bl = false;
        Font font = this.biggestFont;
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(font);
        int n2 = font.getSize();
        String string2 = font.getName();
        int n3 = font.getStyle();
        while (!bl) {
            if (fontMetrics.getHeight() <= 17 && fontMetrics.stringWidth(string) <= n) {
                bl = true;
                continue;
            }
            if (n2 <= 6) {
                bl = true;
                continue;
            }
            font = new Font(string2, n3, --n2);
            fontMetrics = ((Component)this).getFontMetrics(font);
        }
        graphics.setFont(font);
        this.setFont(font);
        return fontMetrics;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        int n = dimension.width - insets.left - insets.right;
        int n2 = dimension.height - insets.top - insets.bottom;
        int n3 = n / 7;
        int n4 = n2 / 2;
        if (this.totalSize == null || this.totalSize.width != n || this.totalSize.height != n2) {
            this.totalSize = new Dimension(n, n2);
            this.fontMetrics = this.pickFont(graphics, "drawRoundRect", n3);
        }
        Color color = Color.lightGray;
        int n5 = insets.left + 3;
        int n6 = insets.top + 3;
        int n7 = n5;
        int n8 = n6;
        int n9 = n3 - 2 * n7;
        int n10 = n4 - 5 - this.fontMetrics.getDescent();
        int n11 = n10 - this.fontMetrics.getMaxAscent() - n8 - 2;
        graphics.drawLine(n7, n8 + n11 - 1, n7 + n9, n8);
        graphics.drawString("drawLine", n7, n10);
        graphics.drawRect(n7 += n3, n8, n9, n11);
        graphics.drawString("drawRect", n7, n10);
        graphics.setColor(color);
        graphics.draw3DRect(n7 += n3, n8, n9, n11, true);
        graphics.setColor(this.fg);
        graphics.drawString("draw3DRect", n7, n10);
        graphics.drawRoundRect(n7 += n3, n8, n9, n11, 10, 10);
        graphics.drawString("drawRoundRect", n7, n10);
        graphics.drawOval(n7 += n3, n8, n9, n11);
        graphics.drawString("drawOval", n7, n10);
        graphics.drawArc(n7 += n3, n8, n9, n11, 90, 135);
        graphics.drawString("drawArc", n7, n10);
        int[] nArray = new int[]{n7 += n3, n7 + n9, n7, n7 + n9};
        int[] nArray2 = new int[]{n8, n8 + n11, n8 + n11, n8};
        graphics.drawPolygon(nArray, nArray2, nArray.length);
        graphics.drawString("drawPolygon", n7, n10);
        n7 = n5;
        int[] nArray3 = new int[]{n7, n7 + n9, n7, n7 + n9};
        int[] nArray4 = new int[]{n8 += n4, n8 + n11, n8 + n11, n8};
        graphics.drawPolyline(nArray3, nArray4, nArray3.length);
        graphics.drawString("drawPolyline", n7, n10 += n4);
        graphics.fillRect(n7 += n3, n8, n9, n11);
        graphics.drawString("fillRect", n7, n10);
        graphics.setColor(color);
        graphics.fill3DRect(n7 += n3, n8, n9, n11, true);
        graphics.setColor(this.fg);
        graphics.drawString("fill3DRect", n7, n10);
        graphics.fillRoundRect(n7 += n3, n8, n9, n11, 10, 10);
        graphics.drawString("fillRoundRect", n7, n10);
        graphics.fillOval(n7 += n3, n8, n9, n11);
        graphics.drawString("fillOval", n7, n10);
        graphics.fillArc(n7 += n3, n8, n9, n11, 90, 135);
        graphics.drawString("fillArc", n7, n10);
        int[] nArray5 = new int[]{n7 += n3, n7 + n9, n7, n7 + n9};
        int[] nArray6 = new int[]{n8, n8 + n11, n8 + n11, n8};
        graphics.fillPolygon(nArray5, nArray6, nArray5.length);
        graphics.drawString("fillPolygon", n7, n10);
    }
}

