/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;

public class Rule
extends JComponent
implements Accessible {
    public static final int INCH = Toolkit.getDefaultToolkit().getScreenResolution();
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int SIZE = 35;
    public int orientation;
    public boolean isMetric;
    private int increment;
    private int units;

    public Rule(int n, boolean bl) {
        this.orientation = n;
        this.isMetric = bl;
        this.setIncrementAndUnits();
    }

    public void setIsMetric(boolean bl) {
        if (this.accessibleContext != null && this.isMetric != bl) {
            if (bl) {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleRulerState.INCHES, AccessibleRulerState.CENTIMETERS);
            } else {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleRulerState.CENTIMETERS, AccessibleRulerState.INCHES);
            }
        }
        this.isMetric = bl;
        this.setIncrementAndUnits();
        this.repaint();
    }

    private void setIncrementAndUnits() {
        if (this.isMetric) {
            this.increment = this.units = (int)((double)INCH / 2.54);
        } else {
            this.units = INCH;
            this.increment = this.units / 2;
        }
    }

    public boolean isMetric() {
        return this.isMetric;
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setPreferredHeight(int n) {
        this.setPreferredSize(new Dimension(35, n));
    }

    public void setPreferredWidth(int n) {
        this.setPreferredSize(new Dimension(n, 35));
    }

    public void paintComponent(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(new Color(230, 163, 4));
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setFont(new Font("SansSerif", 0, 10));
        graphics.setColor(Color.black);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = null;
        if (this.orientation == 0) {
            n2 = rectangle.x / this.increment * this.increment;
            n = ((rectangle.x + rectangle.width) / this.increment + 1) * this.increment;
        } else {
            n2 = rectangle.y / this.increment * this.increment;
            n = ((rectangle.y + rectangle.height) / this.increment + 1) * this.increment;
        }
        if (n2 == 0) {
            string = Integer.toString(0) + (this.isMetric ? " cm" : " in");
            n3 = 10;
            if (this.orientation == 0) {
                graphics.drawLine(0, 34, 0, 35 - n3 - 1);
                graphics.drawString(string, 2, 21);
            } else {
                graphics.drawLine(34, 0, 35 - n3 - 1, 0);
                graphics.drawString(string, 9, 10);
            }
            string = null;
            n2 = this.increment;
        }
        int n4 = n2;
        while (n4 < n) {
            if (n4 % this.units == 0) {
                n3 = 10;
                string = Integer.toString(n4 / this.units);
            } else {
                n3 = 7;
                string = null;
            }
            if (n3 != 0) {
                if (this.orientation == 0) {
                    graphics.drawLine(n4, 34, n4, 35 - n3 - 1);
                    if (string != null) {
                        graphics.drawString(string, n4 - 3, 21);
                    }
                } else {
                    graphics.drawLine(34, n4, 35 - n3 - 1, n4);
                    if (string != null) {
                        graphics.drawString(string, 9, n4 + 3);
                    }
                }
            }
            n4 += this.increment;
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleRuler();
        }
        return this.accessibleContext;
    }

    protected class AccessibleRuler
    extends JComponent.AccessibleJComponent {
        protected AccessibleRuler() {
            super(Rule.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRuleRole.RULER;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (Rule.this.orientation == 1) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            } else {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            }
            if (Rule.this.isMetric) {
                accessibleStateSet.add(AccessibleRulerState.CENTIMETERS);
            } else {
                accessibleStateSet.add(AccessibleRulerState.INCHES);
            }
            return accessibleStateSet;
        }
    }
}

