/*
 * Decompiled with CFR 0.152.
 */
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;

public class ArrayListTransferHandler
extends TransferHandler {
    DataFlavor localArrayListFlavor;
    DataFlavor serialArrayListFlavor;
    String localArrayListType = "application/x-java-jvm-local-objectref;class=java.util.ArrayList";
    JList source = null;
    int[] indices = null;
    int addIndex = -1;
    int addCount = 0;
    static /* synthetic */ Class class$java$util$ArrayList;

    public ArrayListTransferHandler() {
        try {
            this.localArrayListFlavor = new DataFlavor(this.localArrayListType);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ArrayListTransferHandler: unable to create data flavor");
        }
        this.serialArrayListFlavor = new DataFlavor(class$java$util$ArrayList == null ? (class$java$util$ArrayList = ArrayListTransferHandler.class$("java.util.ArrayList")) : class$java$util$ArrayList, "ArrayList");
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        ArrayList arrayList;
        JList jList;
        block11: {
            jList = null;
            arrayList = null;
            if (!this.canImport(jComponent, transferable.getTransferDataFlavors())) {
                return false;
            }
            try {
                jList = (JList)jComponent;
                if (this.hasLocalArrayListFlavor(transferable.getTransferDataFlavors())) {
                    arrayList = (ArrayList)transferable.getTransferData(this.localArrayListFlavor);
                    break block11;
                }
                if (this.hasSerialArrayListFlavor(transferable.getTransferDataFlavors())) {
                    arrayList = (ArrayList)transferable.getTransferData(this.serialArrayListFlavor);
                    break block11;
                }
                return false;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                System.out.println("importData: unsupported data flavor");
                return false;
            }
            catch (IOException iOException) {
                System.out.println("importData: I/O exception");
                return false;
            }
        }
        int n = jList.getSelectedIndex();
        if (this.source.equals(jList) && this.indices != null && n >= this.indices[0] - 1 && n <= this.indices[this.indices.length - 1]) {
            this.indices = null;
            return true;
        }
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        int n2 = defaultListModel.getSize();
        if (n < 0) {
            n = n2;
        } else if (++n > n2) {
            n = n2;
        }
        this.addIndex = n;
        this.addCount = arrayList.size();
        int n3 = 0;
        while (n3 < arrayList.size()) {
            defaultListModel.add(n++, arrayList.get(n3));
            ++n3;
        }
        return true;
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (n == 2 && this.indices != null) {
            int n2;
            DefaultListModel defaultListModel = (DefaultListModel)this.source.getModel();
            if (this.addCount > 0) {
                n2 = 0;
                while (n2 < this.indices.length) {
                    if (this.indices[n2] > this.addIndex) {
                        int n3 = n2;
                        this.indices[n3] = this.indices[n3] + this.addCount;
                    }
                    ++n2;
                }
            }
            n2 = this.indices.length - 1;
            while (n2 >= 0) {
                defaultListModel.remove(this.indices[n2]);
                --n2;
            }
        }
        this.indices = null;
        this.addIndex = -1;
        this.addCount = 0;
    }

    private boolean hasLocalArrayListFlavor(DataFlavor[] dataFlavorArray) {
        if (this.localArrayListFlavor == null) {
            return false;
        }
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (dataFlavorArray[n].equals(this.localArrayListFlavor)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean hasSerialArrayListFlavor(DataFlavor[] dataFlavorArray) {
        if (this.serialArrayListFlavor == null) {
            return false;
        }
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (dataFlavorArray[n].equals(this.serialArrayListFlavor)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        if (this.hasLocalArrayListFlavor(dataFlavorArray)) {
            return true;
        }
        return this.hasSerialArrayListFlavor(dataFlavorArray);
    }

    protected Transferable createTransferable(JComponent jComponent) {
        if (jComponent instanceof JList) {
            this.source = (JList)jComponent;
            this.indices = this.source.getSelectedIndices();
            Object[] objectArray = this.source.getSelectedValues();
            if (objectArray == null || objectArray.length == 0) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>(objectArray.length);
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                String string = object.toString();
                if (string == null) {
                    string = "";
                }
                arrayList.add(string);
                ++n;
            }
            return new ArrayListTransferable(arrayList);
        }
        return null;
    }

    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ArrayListTransferable
    implements Transferable {
        ArrayList data;

        public ArrayListTransferable(ArrayList arrayList) {
            this.data = arrayList;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.data;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{ArrayListTransferHandler.this.localArrayListFlavor, ArrayListTransferHandler.this.serialArrayListFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            if (ArrayListTransferHandler.this.localArrayListFlavor.equals(dataFlavor)) {
                return true;
            }
            return ArrayListTransferHandler.this.serialArrayListFlavor.equals(dataFlavor);
        }
    }
}

