/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;

public class SliderDemo3
extends JPanel
implements ActionListener,
WindowListener,
ChangeListener,
PropertyChangeListener {
    static final int FPS_MIN = 0;
    static final int FPS_MAX = 30;
    static final int FPS_INIT = 15;
    int frameNumber = 0;
    int NUM_FRAMES = 14;
    ImageIcon[] images = new ImageIcon[this.NUM_FRAMES];
    int delay;
    Timer timer;
    boolean frozen = false;
    JLabel picture;
    JFormattedTextField textField;
    JSlider framesPerSecond;
    static /* synthetic */ Class class$SliderDemo3;

    public SliderDemo3() {
        this.setLayout(new BoxLayout(this, 3));
        this.delay = 66;
        JLabel jLabel = new JLabel("Frames Per Second: ", 0);
        jLabel.setAlignmentX(0.5f);
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
        numberFormatter.setMinimum(new Integer(0));
        numberFormatter.setMaximum(new Integer(30));
        this.textField = new JFormattedTextField(numberFormatter);
        this.textField.setValue(new Integer(15));
        this.textField.setColumns(5);
        this.textField.addPropertyChangeListener(this);
        this.textField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        this.textField.getActionMap().put("check", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!SliderDemo3.this.textField.isEditValid()) {
                    Toolkit.getDefaultToolkit().beep();
                    SliderDemo3.this.textField.selectAll();
                } else {
                    try {
                        SliderDemo3.this.textField.commitEdit();
                    }
                    catch (ParseException parseException) {}
                }
            }
        });
        this.framesPerSecond = new JSlider(0, 0, 30, 15);
        this.framesPerSecond.addChangeListener(this);
        this.framesPerSecond.setMajorTickSpacing(10);
        this.framesPerSecond.setMinorTickSpacing(1);
        this.framesPerSecond.setPaintTicks(true);
        this.framesPerSecond.setPaintLabels(true);
        this.framesPerSecond.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.picture = new JLabel();
        this.picture.setHorizontalAlignment(0);
        this.picture.setAlignmentX(0.5f);
        this.picture.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.updatePicture(0);
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jPanel.add(this.textField);
        this.add(jPanel);
        this.add(this.framesPerSecond);
        this.add(this.picture);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.timer = new Timer(this.delay, this);
        this.timer.setInitialDelay(this.delay * 7);
        this.timer.setCoalesce(true);
    }

    void addWindowListener(Window window) {
        window.addWindowListener(this);
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.stopAnimation();
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        this.startAnimation();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        int n = jSlider.getValue();
        if (!jSlider.getValueIsAdjusting()) {
            this.textField.setValue(new Integer(n));
            if (n == 0) {
                if (!this.frozen) {
                    this.stopAnimation();
                }
            } else {
                this.delay = 1000 / n;
                this.timer.setDelay(this.delay);
                this.timer.setInitialDelay(this.delay * 10);
                if (this.frozen) {
                    this.startAnimation();
                }
            }
        } else {
            this.textField.setText(String.valueOf(n));
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("value".equals(propertyChangeEvent.getPropertyName())) {
            Number number = (Number)propertyChangeEvent.getNewValue();
            if (this.framesPerSecond != null && number != null) {
                this.framesPerSecond.setValue(number.intValue());
            }
        }
    }

    public void startAnimation() {
        this.timer.start();
        this.frozen = false;
    }

    public void stopAnimation() {
        this.timer.stop();
        this.frozen = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.frameNumber = this.frameNumber == this.NUM_FRAMES - 1 ? 0 : ++this.frameNumber;
        this.updatePicture(this.frameNumber);
        if (this.frameNumber == this.NUM_FRAMES - 1 || this.frameNumber == this.NUM_FRAMES / 2 - 1) {
            this.timer.restart();
        }
    }

    protected void updatePicture(int n) {
        if (this.images[this.frameNumber] == null) {
            this.images[this.frameNumber] = SliderDemo3.createImageIcon("images/doggy/T" + this.frameNumber + ".gif");
        }
        if (this.images[this.frameNumber] != null) {
            this.picture.setIcon(this.images[this.frameNumber]);
        } else {
            this.picture.setText("image #" + this.frameNumber + " not found");
        }
    }

    protected static ImageIcon createImageIcon(String string) {
        URL uRL = (class$SliderDemo3 == null ? (class$SliderDemo3 = SliderDemo3.class$("SliderDemo3")) : class$SliderDemo3).getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    public static void main(String[] stringArray) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("SliderDemo3");
        jFrame.setDefaultCloseOperation(3);
        SliderDemo3 sliderDemo3 = new SliderDemo3();
        sliderDemo3.setOpaque(true);
        jFrame.setContentPane(sliderDemo3);
        jFrame.pack();
        jFrame.setVisible(true);
        sliderDemo3.startAnimation();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

