/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;

public class ProgressMonitorDemo
extends JPanel
implements ActionListener {
    public static final int ONE_SECOND = 1000;
    private ProgressMonitor progressMonitor;
    private Timer timer;
    private JButton startButton;
    private LongTask task = new LongTask();
    private JTextArea taskOutput;
    private String newline = "\n";

    public ProgressMonitorDemo() {
        super(new BorderLayout());
        this.startButton = new JButton("Start");
        this.startButton.setActionCommand("start");
        this.startButton.addActionListener(this);
        this.taskOutput = new JTextArea(5, 20);
        this.taskOutput.setMargin(new Insets(5, 5, 5, 5));
        this.taskOutput.setEditable(false);
        this.add((Component)this.startButton, "First");
        this.add((Component)new JScrollPane(this.taskOutput), "Center");
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.timer = new Timer(1000, new TimerListener());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.progressMonitor = new ProgressMonitor(this, "Running a Long Task", "", 0, this.task.getLengthOfTask());
        this.progressMonitor.setProgress(0);
        this.progressMonitor.setMillisToDecideToPopup(2000);
        this.startButton.setEnabled(false);
        this.task.go();
        this.timer.start();
    }

    public static void main(String[] stringArray) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("ProgressMonitorDemo");
        jFrame.setDefaultCloseOperation(3);
        ProgressMonitorDemo progressMonitorDemo = new ProgressMonitorDemo();
        progressMonitorDemo.setOpaque(true);
        jFrame.setContentPane(progressMonitorDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ProgressMonitorDemo.this.progressMonitor.setProgress(ProgressMonitorDemo.this.task.getCurrent());
            String string = ProgressMonitorDemo.this.task.getMessage();
            if (string != null) {
                ProgressMonitorDemo.this.progressMonitor.setNote(string);
                ProgressMonitorDemo.this.taskOutput.append(string + ProgressMonitorDemo.this.newline);
                ProgressMonitorDemo.this.taskOutput.setCaretPosition(ProgressMonitorDemo.this.taskOutput.getDocument().getLength());
            }
            if (ProgressMonitorDemo.this.progressMonitor.isCanceled() || ProgressMonitorDemo.this.task.isDone()) {
                ProgressMonitorDemo.this.progressMonitor.close();
                ProgressMonitorDemo.this.task.stop();
                Toolkit.getDefaultToolkit().beep();
                ProgressMonitorDemo.this.timer.stop();
                if (ProgressMonitorDemo.this.task.isDone()) {
                    ProgressMonitorDemo.this.taskOutput.append("Task completed." + ProgressMonitorDemo.this.newline);
                } else {
                    ProgressMonitorDemo.this.taskOutput.append("Task canceled." + ProgressMonitorDemo.this.newline);
                }
                ProgressMonitorDemo.this.startButton.setEnabled(true);
            }
        }
    }
}

