/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;

public class ProgressBarDemo2
extends JPanel
implements ActionListener {
    public static final int ONE_SECOND = 1000;
    private JProgressBar progressBar;
    private Timer timer;
    private JButton startButton;
    private LongTask task = new LongTask();
    private JTextArea taskOutput;
    private String newline = "\n";

    public ProgressBarDemo2() {
        super(new BorderLayout());
        this.startButton = new JButton("Start");
        this.startButton.setActionCommand("start");
        this.startButton.addActionListener(this);
        this.progressBar = new JProgressBar(0, this.task.getLengthOfTask());
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("");
        this.taskOutput = new JTextArea(5, 20);
        this.taskOutput.setMargin(new Insets(5, 5, 5, 5));
        this.taskOutput.setEditable(false);
        JPanel jPanel = new JPanel();
        jPanel.add(this.startButton);
        jPanel.add(this.progressBar);
        this.add((Component)jPanel, "First");
        this.add((Component)new JScrollPane(this.taskOutput), "Center");
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgressBarDemo2.this.progressBar.setValue(ProgressBarDemo2.this.task.getCurrent());
                String string = ProgressBarDemo2.this.task.getMessage();
                if (string != null) {
                    if (ProgressBarDemo2.this.progressBar.isIndeterminate()) {
                        ProgressBarDemo2.this.progressBar.setIndeterminate(false);
                        ProgressBarDemo2.this.progressBar.setString(null);
                    }
                    ProgressBarDemo2.this.taskOutput.append(string + ProgressBarDemo2.this.newline);
                    ProgressBarDemo2.this.taskOutput.setCaretPosition(ProgressBarDemo2.this.taskOutput.getDocument().getLength());
                }
                if (ProgressBarDemo2.this.task.isDone()) {
                    Toolkit.getDefaultToolkit().beep();
                    ProgressBarDemo2.this.timer.stop();
                    ProgressBarDemo2.this.startButton.setEnabled(true);
                    ProgressBarDemo2.this.progressBar.setValue(ProgressBarDemo2.this.progressBar.getMinimum());
                    ProgressBarDemo2.this.progressBar.setString("");
                }
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.progressBar.setIndeterminate(true);
        this.startButton.setEnabled(false);
        this.task.go();
        this.timer.start();
    }

    public static void main(String[] stringArray) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("ProgressBarDemo2");
        jFrame.setDefaultCloseOperation(3);
        ProgressBarDemo2 progressBarDemo2 = new ProgressBarDemo2();
        progressBarDemo2.setOpaque(true);
        jFrame.setContentPane(progressBarDemo2);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

