/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FormattedTextFieldDemo
extends JPanel
implements PropertyChangeListener {
    private double amount = 100000.0;
    private double rate = 7.5;
    private int numPeriods = 30;
    private double payment = 0.0;
    private JLabel amountLabel;
    private JLabel rateLabel;
    private JLabel numPeriodsLabel;
    private JLabel paymentLabel;
    private static String amountString = "Loan Amount: ";
    private static String rateString = "APR (%): ";
    private static String numPeriodsString = "Years: ";
    private static String paymentString = "Monthly Payment: ";
    private JFormattedTextField amountField;
    private JFormattedTextField rateField;
    private JFormattedTextField numPeriodsField;
    private JFormattedTextField paymentField;
    private NumberFormat moneyFormat;
    private NumberFormat percentFormat;
    private DecimalFormat paymentFormat;

    public FormattedTextFieldDemo() {
        super(new BorderLayout());
        this.setUpFormats();
        this.payment = this.computePayment(this.amount, this.rate, this.numPeriods);
        this.amountLabel = new JLabel(amountString);
        this.rateLabel = new JLabel(rateString);
        this.numPeriodsLabel = new JLabel(numPeriodsString);
        this.paymentLabel = new JLabel(paymentString);
        this.amountField = new JFormattedTextField(this.moneyFormat);
        this.amountField.setValue(new Double(this.amount));
        this.amountField.setColumns(10);
        this.amountField.addPropertyChangeListener(this);
        this.amountField.setFocusLostBehavior(1);
        this.rateField = new JFormattedTextField(this.percentFormat);
        this.rateField.setValue(new Double(this.rate));
        this.rateField.setColumns(10);
        this.rateField.addPropertyChangeListener(this);
        this.rateField.setFocusLostBehavior(1);
        this.numPeriodsField = new JFormattedTextField();
        this.numPeriodsField.setValue(new Integer(this.numPeriods));
        this.numPeriodsField.setColumns(10);
        this.numPeriodsField.addPropertyChangeListener(this);
        this.numPeriodsField.setFocusLostBehavior(1);
        this.paymentField = new JFormattedTextField(this.paymentFormat);
        this.paymentField.setValue(new Double(this.payment));
        this.paymentField.setColumns(10);
        this.paymentField.setEditable(false);
        this.paymentField.setForeground(Color.red);
        this.amountLabel.setLabelFor(this.amountField);
        this.rateLabel.setLabelFor(this.rateField);
        this.numPeriodsLabel.setLabelFor(this.numPeriodsField);
        this.paymentLabel.setLabelFor(this.paymentField);
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.add(this.amountLabel);
        jPanel.add(this.rateLabel);
        jPanel.add(this.numPeriodsLabel);
        jPanel.add(this.paymentLabel);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
        jPanel2.add(this.amountField);
        jPanel2.add(this.rateField);
        jPanel2.add(this.numPeriodsField);
        jPanel2.add(this.paymentField);
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "After");
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("value".equals(propertyChangeEvent.getPropertyName())) {
            Object object = propertyChangeEvent.getSource();
            if (object == this.amountField) {
                this.amount = ((Number)this.amountField.getValue()).doubleValue();
            } else if (object == this.rateField) {
                this.rate = ((Number)this.rateField.getValue()).doubleValue();
            } else if (object == this.numPeriodsField) {
                this.numPeriods = ((Number)this.numPeriodsField.getValue()).intValue();
            }
            this.payment = this.computePayment(this.amount, this.rate, this.numPeriods);
            this.paymentField.setValue(new Double(this.payment));
        }
    }

    public static void main(String[] stringArray) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("FormattedTextFieldDemo");
        jFrame.setDefaultCloseOperation(3);
        FormattedTextFieldDemo formattedTextFieldDemo = new FormattedTextFieldDemo();
        formattedTextFieldDemo.setOpaque(true);
        jFrame.setContentPane(formattedTextFieldDemo);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    double computePayment(double d, double d2, int n) {
        double d3 = d2 / 100.0 / 12.0;
        double d4 = Math.pow(1.0 + d3, 0.0 - (double)(n *= 12));
        double d5 = (1.0 - d4) / d3;
        double d6 = -1.0 * d / d5;
        return d6;
    }

    private void setUpFormats() {
        this.moneyFormat = NumberFormat.getNumberInstance();
        this.percentFormat = NumberFormat.getNumberInstance();
        this.percentFormat.setMinimumFractionDigits(3);
        this.paymentFormat = (DecimalFormat)NumberFormat.getNumberInstance();
        this.paymentFormat.setMaximumFractionDigits(2);
        this.paymentFormat.setNegativePrefix("(");
        this.paymentFormat.setNegativeSuffix(")");
    }
}

