/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;

public class DialogDemo
extends JPanel {
    JLabel label;
    ImageIcon icon = DialogDemo.createImageIcon("images/middle.gif");
    JFrame frame;
    String simpleDialogDesc = "Some simple message dialogs";
    String iconDesc = "A JOptionPane has its choice of icons";
    String moreDialogDesc = "Some more dialogs";
    CustomDialog customDialog;
    static /* synthetic */ Class class$DialogDemo;

    public DialogDemo(JFrame jFrame) {
        super(new BorderLayout());
        this.frame = jFrame;
        this.customDialog = new CustomDialog((Frame)jFrame, "geisel", this);
        this.customDialog.pack();
        JPanel jPanel = this.createSimpleDialogBox();
        JPanel jPanel2 = this.createFeatureDialogBox();
        JPanel jPanel3 = this.createIconDialogBox();
        this.label = new JLabel("Click the \"Show it!\" button to bring up the selected dialog.", 0);
        Border border = BorderFactory.createEmptyBorder(20, 20, 5, 20);
        jPanel.setBorder(border);
        jPanel2.setBorder(border);
        jPanel3.setBorder(border);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Simple Modal Dialogs", null, jPanel, this.simpleDialogDesc);
        jTabbedPane.addTab("More Dialogs", null, jPanel2, this.moreDialogDesc);
        jTabbedPane.addTab("Dialog Icons", null, jPanel3, this.iconDesc);
        this.add((Component)jTabbedPane, "Center");
        this.add((Component)this.label, "Last");
        this.label.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    void setLabel(String string) {
        this.label.setText(string);
    }

    protected static ImageIcon createImageIcon(String string) {
        URL uRL = (class$DialogDemo == null ? (class$DialogDemo = DialogDemo.class$("DialogDemo")) : class$DialogDemo).getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    private JPanel createSimpleDialogBox() {
        JRadioButton[] jRadioButtonArray = new JRadioButton[4];
        final ButtonGroup buttonGroup = new ButtonGroup();
        JButton jButton = null;
        jRadioButtonArray[0] = new JRadioButton("OK (in the L&F's words)");
        jRadioButtonArray[0].setActionCommand("default");
        jRadioButtonArray[1] = new JRadioButton("Yes/No (in the L&F's words)");
        jRadioButtonArray[1].setActionCommand("yesno");
        jRadioButtonArray[2] = new JRadioButton("Yes/No (in the programmer's words)");
        jRadioButtonArray[2].setActionCommand("yeahnah");
        jRadioButtonArray[3] = new JRadioButton("Yes/No/Cancel (in the programmer's words)");
        jRadioButtonArray[3].setActionCommand("ync");
        int n = 0;
        while (n < 4) {
            buttonGroup.add(jRadioButtonArray[n]);
            ++n;
        }
        jRadioButtonArray[0].setSelected(true);
        jButton = new JButton("Show it!");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = buttonGroup.getSelection().getActionCommand();
                if (string == "default") {
                    JOptionPane.showMessageDialog(DialogDemo.this.frame, "Eggs aren't supposed to be green.");
                } else if (string == "yesno") {
                    int n = JOptionPane.showConfirmDialog(DialogDemo.this.frame, "Would you like green eggs and ham?", "An Inane Question", 0);
                    if (n == 0) {
                        DialogDemo.this.setLabel("Ewww!");
                    } else if (n == 1) {
                        DialogDemo.this.setLabel("Me neither!");
                    } else {
                        DialogDemo.this.setLabel("Come on -- tell me!");
                    }
                } else if (string == "yeahnah") {
                    Object[] objectArray = new Object[]{"Yes, please", "No way!"};
                    int n = JOptionPane.showOptionDialog(DialogDemo.this.frame, "Would you like green eggs and ham?", "A Silly Question", 0, 3, null, objectArray, objectArray[0]);
                    if (n == 0) {
                        DialogDemo.this.setLabel("You're kidding!");
                    } else if (n == 1) {
                        DialogDemo.this.setLabel("I don't like them, either.");
                    } else {
                        DialogDemo.this.setLabel("Come on -- 'fess up!");
                    }
                } else if (string == "ync") {
                    Object[] objectArray = new Object[]{"Yes, please", "No, thanks", "No eggs, no ham!"};
                    int n = JOptionPane.showOptionDialog(DialogDemo.this.frame, "Would you like some green eggs to go with that ham?", "A Silly Question", 1, 3, null, objectArray, objectArray[2]);
                    if (n == 0) {
                        DialogDemo.this.setLabel("Here you go: green eggs and ham!");
                    } else if (n == 1) {
                        DialogDemo.this.setLabel("OK, just the ham, then.");
                    } else if (n == 2) {
                        DialogDemo.this.setLabel("Well, I'm certainly not going to eat them!");
                    } else {
                        DialogDemo.this.setLabel("Please tell me what you want!");
                    }
                }
            }
        });
        return this.createPane(this.simpleDialogDesc + ":", jRadioButtonArray, jButton);
    }

    private JPanel createPane(String string, JRadioButton[] jRadioButtonArray, JButton jButton) {
        int n = jRadioButtonArray.length;
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(string);
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.add(jLabel);
        int n2 = 0;
        while (n2 < n) {
            jPanel.add(jRadioButtonArray[n2]);
            ++n2;
        }
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "First");
        jPanel2.add((Component)jButton, "Last");
        return jPanel2;
    }

    private JPanel create2ColPane(String string, JRadioButton[] jRadioButtonArray, JButton jButton) {
        JLabel jLabel = new JLabel(string);
        int n = jRadioButtonArray.length / 2;
        JPanel jPanel = new JPanel(new GridLayout(0, 2));
        int n2 = 0;
        while (n2 < n) {
            jPanel.add(jRadioButtonArray[n2]);
            jPanel.add(jRadioButtonArray[n2 + n]);
            ++n2;
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        jPanel2.add(jLabel);
        jPanel.setAlignmentX(0.0f);
        jPanel2.add(jPanel);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "First");
        jPanel3.add((Component)jButton, "Last");
        return jPanel3;
    }

    private JPanel createIconDialogBox() {
        JButton jButton = null;
        JRadioButton[] jRadioButtonArray = new JRadioButton[6];
        final ButtonGroup buttonGroup = new ButtonGroup();
        jRadioButtonArray[0] = new JRadioButton("Plain (no icon)");
        jRadioButtonArray[0].setActionCommand("plain");
        jRadioButtonArray[1] = new JRadioButton("Information icon");
        jRadioButtonArray[1].setActionCommand("info");
        jRadioButtonArray[2] = new JRadioButton("Question icon");
        jRadioButtonArray[2].setActionCommand("question");
        jRadioButtonArray[3] = new JRadioButton("Error icon");
        jRadioButtonArray[3].setActionCommand("error");
        jRadioButtonArray[4] = new JRadioButton("Warning icon");
        jRadioButtonArray[4].setActionCommand("warning");
        jRadioButtonArray[5] = new JRadioButton("Custom icon");
        jRadioButtonArray[5].setActionCommand("custom");
        int n = 0;
        while (n < 6) {
            buttonGroup.add(jRadioButtonArray[n]);
            ++n;
        }
        jRadioButtonArray[0].setSelected(true);
        jButton = new JButton("Show it!");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = buttonGroup.getSelection().getActionCommand();
                if (string == "plain") {
                    JOptionPane.showMessageDialog(DialogDemo.this.frame, "Eggs aren't supposed to be green.", "A plain message", -1);
                } else if (string == "info") {
                    JOptionPane.showMessageDialog(DialogDemo.this.frame, "Eggs aren't supposed to be green.", "Inane informational dialog", 1);
                } else if (string == "question") {
                    JOptionPane.showMessageDialog(DialogDemo.this.frame, "You shouldn't use a message dialog (like this)\nfor a question, OK?", "Inane question", 3);
                } else if (string == "error") {
                    JOptionPane.showMessageDialog(DialogDemo.this.frame, "Eggs aren't supposed to be green.", "Inane error", 0);
                } else if (string == "warning") {
                    JOptionPane.showMessageDialog(DialogDemo.this.frame, "Eggs aren't supposed to be green.", "Inane warning", 2);
                } else if (string == "custom") {
                    JOptionPane.showMessageDialog(DialogDemo.this.frame, "Eggs aren't supposed to be green.", "Inane custom dialog", 1, DialogDemo.this.icon);
                }
            }
        });
        return this.create2ColPane(this.iconDesc + ":", jRadioButtonArray, jButton);
    }

    private JPanel createFeatureDialogBox() {
        JRadioButton[] jRadioButtonArray = new JRadioButton[5];
        final ButtonGroup buttonGroup = new ButtonGroup();
        JButton jButton = null;
        jRadioButtonArray[0] = new JRadioButton("Pick one of several choices");
        jRadioButtonArray[0].setActionCommand("pickone");
        jRadioButtonArray[1] = new JRadioButton("Enter some text");
        jRadioButtonArray[1].setActionCommand("textfield");
        jRadioButtonArray[2] = new JRadioButton("Non-auto-closing dialog");
        jRadioButtonArray[2].setActionCommand("nonautooption");
        jRadioButtonArray[3] = new JRadioButton("Input-validating dialog (with custom message area)");
        jRadioButtonArray[3].setActionCommand("customoption");
        jRadioButtonArray[4] = new JRadioButton("Non-modal dialog");
        jRadioButtonArray[4].setActionCommand("nonmodal");
        int n = 0;
        while (n < 5) {
            buttonGroup.add(jRadioButtonArray[n]);
            ++n;
        }
        jRadioButtonArray[0].setSelected(true);
        jButton = new JButton("Show it!");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = buttonGroup.getSelection().getActionCommand();
                if (string == "pickone") {
                    Object[] objectArray = new Object[]{"ham", "spam", "yam"};
                    String string2 = (String)JOptionPane.showInputDialog(DialogDemo.this.frame, "Complete the sentence:\n\"Green eggs and...\"", "Customized Dialog", -1, DialogDemo.this.icon, objectArray, "ham");
                    if (string2 != null && string2.length() > 0) {
                        DialogDemo.this.setLabel("Green eggs and... " + string2 + "!");
                        return;
                    }
                    DialogDemo.this.setLabel("Come on, finish the sentence!");
                } else if (string == "textfield") {
                    String string3 = (String)JOptionPane.showInputDialog(DialogDemo.this.frame, "Complete the sentence:\n\"Green eggs and...\"", "Customized Dialog", -1, DialogDemo.this.icon, null, "ham");
                    if (string3 != null && string3.length() > 0) {
                        DialogDemo.this.setLabel("Green eggs and... " + string3 + "!");
                        return;
                    }
                    DialogDemo.this.setLabel("Come on, finish the sentence!");
                } else if (string == "nonautooption") {
                    JOptionPane jOptionPane = new JOptionPane("The only way to close this dialog is by\npressing one of the following buttons.\nDo you understand?", 3, 0);
                    JDialog.setDefaultLookAndFeelDecorated(false);
                    JDialog jDialog = new JDialog(DialogDemo.this.frame, "Click a button", true);
                    jDialog.setContentPane(jOptionPane);
                    jDialog.setDefaultCloseOperation(0);
                    jDialog.addWindowListener(new WindowAdapter(this){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void windowClosing(WindowEvent windowEvent) {
                            3.access$000(this.this$1).setLabel("Thwarted user attempt to close window.");
                        }
                    });
                    JDialog.setDefaultLookAndFeelDecorated(true);
                    jOptionPane.addPropertyChangeListener(new PropertyChangeListener(this, jDialog, jOptionPane){
                        private final /* synthetic */ JDialog val$dialog;
                        private final /* synthetic */ JOptionPane val$optionPane;
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$dialog = jDialog;
                            this.val$optionPane = jOptionPane;
                        }

                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            String string = propertyChangeEvent.getPropertyName();
                            if (this.val$dialog.isVisible() && propertyChangeEvent.getSource() == this.val$optionPane && "value".equals(string)) {
                                this.val$dialog.setVisible(false);
                            }
                        }
                    });
                    jDialog.pack();
                    jDialog.setLocationRelativeTo(DialogDemo.this.frame);
                    jDialog.setVisible(true);
                    int n = (Integer)jOptionPane.getValue();
                    if (n == 0) {
                        DialogDemo.this.setLabel("Good.");
                    } else if (n == 1) {
                        DialogDemo.this.setLabel("Try using the window decorations to close the non-auto-closing dialog. You can't!");
                    } else {
                        DialogDemo.this.setLabel("Window unavoidably closed (ESC?).");
                    }
                } else if (string == "customoption") {
                    DialogDemo.this.customDialog.setLocationRelativeTo(DialogDemo.this.frame);
                    DialogDemo.this.customDialog.setVisible(true);
                    String string4 = DialogDemo.this.customDialog.getValidatedText();
                    if (string4 != null) {
                        DialogDemo.this.setLabel("Congratulations!  You entered \"" + string4 + "\".");
                    }
                } else if (string == "nonmodal") {
                    JDialog jDialog = new JDialog((Frame)DialogDemo.this.frame, "A Non-Modal Dialog");
                    JLabel jLabel = new JLabel("<html><p align=center>This is a non-modal dialog.<br>You can have one or more of these up<br>and still use the main window.");
                    jLabel.setHorizontalAlignment(0);
                    Font font = jLabel.getFont();
                    jLabel.setFont(jLabel.getFont().deriveFont(0, 14.0f));
                    JButton jButton = new JButton("Close");
                    jButton.addActionListener(new ActionListener(this, jDialog){
                        private final /* synthetic */ JDialog val$dialog;
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$dialog = jDialog;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            this.val$dialog.setVisible(false);
                            this.val$dialog.dispose();
                        }
                    });
                    JPanel jPanel = new JPanel();
                    jPanel.setLayout(new BoxLayout(jPanel, 2));
                    jPanel.add(Box.createHorizontalGlue());
                    jPanel.add(jButton);
                    jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
                    JPanel jPanel2 = new JPanel(new BorderLayout());
                    jPanel2.add((Component)jLabel, "Center");
                    jPanel2.add((Component)jPanel, "Last");
                    jPanel2.setOpaque(true);
                    jDialog.setContentPane(jPanel2);
                    jDialog.setSize(new Dimension(300, 150));
                    jDialog.setLocationRelativeTo(DialogDemo.this.frame);
                    jDialog.setVisible(true);
                }
            }

            static /* synthetic */ DialogDemo access$000(3 var0) {
                return var0.DialogDemo.this;
            }
        });
        return this.createPane(this.moreDialogDesc + ":", jRadioButtonArray, jButton);
    }

    public static void main(String[] stringArray) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("DialogDemo");
        jFrame.setDefaultCloseOperation(3);
        Container container = jFrame.getContentPane();
        container.setLayout(new GridLayout(1, 1));
        container.add(new DialogDemo(jFrame));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

