//PicturePanel.java --- CopyLeft by tsaiwn@csie.nctu.edu.tw
import java.awt.*;
class PicturePanel extends Panel {
   String filename = null;
   String caption = null;
   Image image = null;
   boolean wantResize = false;   // fill the full panel when this is true
   public PicturePanel(String filename, boolean wantResize) {
      this(filename, "", wantResize);   // call other Constructor
   }
   public PicturePanel(String filename) {
      this(filename, "", false);   // call other Constructor
   }
   public PicturePanel(String filename, String caption) {
      this(filename, caption, false);   // call other Constructor
   }
   public PicturePanel(String filename, String caption, boolean w) {
      this.wantResize = w;
      this.filename = filename;
      this.caption = caption;
      try {
         Toolkit tkt = Toolkit.getDefaultToolkit( );
         Class me = getClass( );   // get The class is running
         //MyApplet. printf(" getClass() = " + me +"\n");
         java.net.URL url = me.getResource(filename);
         image = tkt.getImage( url ); // works for both Application+Applet
        // Only those Applets hosted in a Browser can obtain CodeBase
        /// .. and DocumentBase using getCodeBase( ) and getDocumentBase( )
        /// .. Since this PicturePanel is not an Applet, the
        /// method getCodeBase() doesn't work even you call it from an Applet
      } catch (Exception e) { ; }
      repaint( );
   }
   public void update(Graphics g) {
       paint(g);   // call paint directly without clear the panel
   }
   public void paint(Graphics g) {
      int xpos = 12, ypos = 12;
      if(image!=null) {
         int width = 0;
         int height = 38;
         try {
            width = image.getWidth(this);   // image's width
            height = image.getHeight(this);
         } catch (Exception e) {;}
         if(wantResize)
         try {
             width = getSize().width;   // current Panel's width
             height = getSize().height;
         } catch (Exception e) {;}
         if(width == 0)
            g.drawImage(image, 2, 2, this );     // Align left-upper corner
         else
            g.drawImage(image, 2, 2, width, height, this );  
      // now paint the caption
         try {
            xpos = image.getWidth(this)/4;
            ypos = image.getHeight(this) - 24;
         }catch(Exception e) {;}
      }
      if(caption != null) {
          g.setFont(new Font("ө", Font.PLAIN, 18) );
          g.setColor(Color.red);
          g.drawString( caption, xpos, ypos );
      }
   } // paint
} // PicturePanel
