//gHanoi3.java -- Graphics Hanoi, by tsaiwn@cs.nctu.edu.tw
//javac gHanoi3.java
//java gHanoi3
///in HTML file,
//    <APPLET code="gHanoi3.class" width=533 height=500>
///
import java.io.*;
import java.applet.*;
import java.awt.*;
import java.awt.event.*;

public class gHanoi3 extends Applet implements MouseListener {
  static Frame f=null;
  //Panel myPanel;
  static boolean isApplet = true;

  public static final int DELAY_TIME = 35; // 35/1000 second
  public static final int MOVE_STEP = 50; // 50 points
  ///
  public static final int MIN_STEP = 8; // 8 points
  public static final int MAX_STEP = 88; // 88 points
  public static final int MAX_DELAY = 68; // 68 milli sec
  public static final int MIN_DELAY = 1; 

  public static boolean speedUp = false;  // speed up?
  public static int delayTime = DELAY_TIME; 
  public static int step = MOVE_STEP;

  public static final int X_SIZE=500, Y_SIZE=500;
  public static final int Y_TOP = 38;
  public static final Color haColor = Color.red;
  public static final Color bgColor = Color.white;
  int kkk=0;  // used in paint(
  ///
  int nDisks = 0;
  int nPeg[ ] = new int[3];
  int xPosition[ ] = new int[3];  // central position of 3 pegs
  int aX=38, aY= (Y_SIZE - 50);
  int bX=(aX+(X_SIZE-50)/3), bY=aY;
  int cX=(bX+(X_SIZE-50)/3), cY=aY;

  int thick=22; // for disk thick
  int width=33; // for disk width
  int wUnit=2;  // 128/nDisks == 2

  Graphics bufferGraphics=null;  // ΨӵebO骺  
  Image img=null;  // The image that will contain everything that ..
              /// .. has been drawn on bufferGraphics.
              /// .. will be used in paint( ) 
  Dimension dim=null;   // To get the width and height of the applet. 

  PrintStream cout=null;
  BufferedReader br = null;

   public static void main(String xxx[ ]) {
      isApplet = false;
      f = new Frame("Tower of Hanoi");
      f.setSize(X_SIZE, Y_SIZE);  // 500,500
      gHanoi3 g3 = new gHanoi3( );
      f.add("Center", g3); 
      f.setVisible(true);  // f.show( );
      g3.init( );
      g3.start( );
      g3.main( );
   }

   public gHanoi3( ) {  }

   public void init( ) {
      prepareIO( );
      //repaint( ); // force to initilize img
      prepareImagePaper( );
      addMouseListener(this); // MouseEvent
   }//init(

   public void start( ) {
      if(isApplet) { 
         setVisible(true);  repaint( );
         doHanoi(5);  // not from main( 
      }// if
   }// start(

   void prepareImagePaper( ) {
     if(bufferGraphics == null) {
        setVisible(true);
        // Create an offscreen image to draw on , same size
        dim = getSize( );  // obtain the width and height
        img = createImage(dim.width, dim.height); 
        bufferGraphics = img.getGraphics( );  
        // use Graphics methods to draw, this is double buffer
        return;
     }//if
   } // prepareImagePaper( 

  void prepareIO( ){
     try{
        cout = System.out;
        br = new BufferedReader(
               new InputStreamReader(System.in) );
     }catch(Exception e) {
        e.printStackTrace( );
        System.exit(38);
     }//try
  }
// hanoi.c  -- Hanoi tower, @CopyLeft by tsaiwn@csie.nctu.edu.tw
//Hanoi Tower(e) -- _ Recursive -- ۤvsۤv !
// Hanoi Tower, Х http://gogle.com J "hanoi tower"  d
//`N޸p "hanoi tower" d쪺~OAn :-)
//άOݳo  http://en.wikipedia.org/wiki/Tower_of_Hanoi
///
//void moveOne(int px, int py, int ); //3rd parameter is the disk#
void hanoi(int n, int pa, int pc, int pb) {
    if(n==0) return;    // there is no disk
    hanoi(n-1, pa, pb, pc);  // ڧW n-1 disks h
    moveOne(pa, pc, n);   /// move the n-th disk from pa to pc
    hanoi(n-1, pb, pc, pa); // move n-1 disks from pb to pc
} // hanoi

//#include <stdio.h>
void moveOne(int px, int py, int n ) {  // the n-th disk
   moveG(px, py, n);
   String p123[ ] = {"th", "st", "nd", "rd"}; // -th, Fir-st, Seco-nd, -rd
   int k = n%10;
   if(k!=1  && k!=2 && k!=3) k = 0;  // -th
   cout.printf("Move %d-%s disk from %c  to  %c \n", n,p123[k], px, py);
}

int getInt( ) {   // static char buf[99];
   String buf = null;
   int ans=0;
   // fgets(buf, sizeof(buf), stdin); ans=atoi(buf);
   try {
      buf = br.readLine( );
      ans = Integer.parseInt(buf);
   }catch(Exception e) { ans = 3; }
    // pG ans = 3; אּ ans = 64; A{|h[? ? ?
   return ans;  //Y@uh@Ӱʧ@, hݬ 600 billion(d) years
}
void haInit(int n) {
    nDisks = n;
    nPeg[0] = n; // initially all Disks on Peg-0
    nPeg[1] = nPeg[2] = 0;
    thick = (Y_SIZE -50)/n;
    if(thick > 20) thick = 20; // disk thick
    wUnit = 128/nDisks;
    if(wUnit < 2) wUnit=2;
    xPosition[0] = aX + 64;
    xPosition[1] = bX + 64;
    xPosition[2] = cX + 64;
    //
    if(f!=null) {
        f.setVisible(true);  // f.show( );
        f.validate( ); f.requestFocus( );
    }
    repaint( ); 
    clearTower( ); 
    initDisks( );  // draw the initial Disks
    if(f!=null)  f.setVisible(true);  // f.show( );
    else setVisible(true); 
}
void doHanoi(int n) {
    if(dim == null  || img==null || bufferGraphics == null) {
        prepareImagePaper( );
        if(bufferGraphics == null) return;  // give up
    }//if
    if(n >= 65) return;
    haInit(n); 
    hanoi(n, 'A', 'C', 'B'); // move n disks on peg 'A' to peg 'C'
}
int main( ) {
    int n;  int firstRun = 1;
    while(true) {
       if(firstRun != 0) {
            firstRun = 0;
            f.setVisible(false);  // hide the window
       }//if
       cout.print(" n=? ");
       n = getInt( );  // read an int into n
       if(n<=0) break;
       f.setVisible(true);  //////  f.show( )
       /// ==========
       doHanoi(n);
       try{Thread.sleep(985);}catch(Exception e) {  }
    }//while
    f.dispose( );
    return 0;
}
//////////////////////////
  void clearTower( ){
     if(dim==null) repaint( );  // try to prepare img again
     if(bufferGraphics == null) return;  // not Ready yet
     setBackground(Color.gray);
     bufferGraphics.clearRect(0,0,dim.width,dim.width);
     bufferGraphics.setColor(Color.pink); 
     bufferGraphics.fillRect(aX-1, aY, 128+2, 18); 
     bufferGraphics.fillRect(bX-1, bY, 128+2, 18);
     bufferGraphics.fillRect(cX-1, cY, 128+2, 18);
     bufferGraphics.setColor(haColor); 
     try{ Thread.sleep(delayTime); }catch(Exception e){ }
     repaint( );
  }//clearTower

  // rewrite update( ) : Always required for good double-buffering.
  // This will cause the Applet not to first wipe off previous 
  // ..drawings but to immediately repaint. 
  // The wiping off  may also causes flickering. 
  // Update is called automatically when repaint( ) is called. 
  //
  // try to comment out next line and then try to run again!
  public void update(Graphics g) { paint(g); }  // s paint( )

  public void paint(Graphics g) {
     if(dim == null  || img==null || bufferGraphics == null) {
        // Create an offscreen image to draw on , same size
        prepareImagePaper( );
        return;
     }//if
     g.drawImage(img, 0, 0, this);   // ɤ~eù
     //System.out.println(" paint "+ ++kkk);
  }//paint(

  void initDisks( ) {   // draw the original Disks
    if(img==null || bufferGraphics == null) {
        prepareImagePaper( );
        if(bufferGraphics == null) return;  // give up
    }// if
    int x, y;
    for(int n= nDisks; n>=1; --n) {
        bufferGraphics.setColor(haColor); 
        x = xPosition[0] - wUnit*n/2;
        y = aY - (nDisks -n+1)*thick;
        bufferGraphics.fillRect(x, y, wUnit*n, thick);
    }//for
    repaint( );
    try{Thread.sleep(delayTime);}catch(Exception e){ }
   }

  void moveG(int px, int py, int n ) {  // the n-th disk
     if(img==null || bufferGraphics == null) return;
     //if(img==null) return;  // not ready yet
     int from = px - 'A';
     int to = py - 'A';
     width = wUnit * n;   // width of n-th disk
     if(width > 128) width = 128;  // limit the width
     moveYUp(from, to, n);
     moveX(from, to, n);
     moveYDown(from, to, n);
     //
     --nPeg[from];  // from == 0? 1? 2?
     ++nPeg[to];
  }//moveG(

  void moveThere(int xa, int ya, int xb, int yb) {
      // width and thick are Global variables
      bufferGraphics.setColor(Color.white ); 
      bufferGraphics.fillRect(xa, ya, width, thick); 
      bufferGraphics.setColor(haColor ); 
      bufferGraphics.fillRect(xb, yb, width, thick); 
      repaint( ); 
      try{Thread.sleep(delayTime);} catch(Exception e){ }
  }

  void moveYUp(int fm, int to, int n ) {  // the n-th disk
     int x,y, y1, y2;
     x = xPosition[fm] - width/2;
     y2 = Y_TOP;
     y1 = aY - nPeg[fm]*thick;  // y-position of n-th disk
     y = y1;   // move y from y1 to y2
     while(y > y2+step) {
         int y0 = y;
         y -= step;
         moveThere(x, y0, x, y);
     }//while(
     moveThere(x, y, x, y2);
  }//moveYUp

  void moveX(int fm, int to, int n ) {  // the n-th disk
     int x,y, x1, x2;
     y = Y_TOP;
     x1 = xPosition[fm]  - width/2;  
     x2 = xPosition[to]  - width/2;;
     boolean toRight = true;
     if(x2 < x1) toRight = false;   // to Left
     // move x from x1 to x2
     x = x1;
     while( true ) {  
        if(x > x2-step) break;   //  Little BUG ??
         // P_ toRight ? or to Left ? MᰵP 
        bufferGraphics.setColor(Color.white ); 
        bufferGraphics.fillRect(x, y, width, thick); 
        x += step;
        bufferGraphics.setColor(haColor); 
        bufferGraphics.fillRect(x, y, width, thick); 
        repaint( ); 
        try{Thread.sleep(delayTime);}catch(Exception e){ }
     }//while(
     moveThere(x, y, x2, y);
     // move to position (x2, Y_TOP) now
  }//moveX

  void moveYDown(int fm, int to, int n ) {  // the n-th disk
     int x,y, y1, y2;
     x = xPosition[to]  - width/2;;
     y1 = Y_TOP;
     y2 = aY - (nPeg[to]+1)*thick;    // destination
     y = y1;   // move y from y1 to y2
     while(y < y2-step) {
        int y0 = y;
        y += step;
        moveThere(x, y0, x, y);
     }//while(
     moveThere(x, y, x, y2);
  }// moveYDown

/// handling MouseEvent
  public void mousePressed(MouseEvent e) { }
  public void mouseReleased(MouseEvent e) { }
  public void mouseEntered(MouseEvent e) {
     step = MOVE_STEP;
     delayTime = DELAY_TIME;
  }
  public void mouseExited(MouseEvent e) { 
     step = MAX_STEP;
     delayTime = MIN_DELAY;
  }
  public void mouseClicked(MouseEvent e) { 
      if(speedUp){
          ++step; ++step; 
          if(step > MAX_STEP) step = MAX_STEP;
          --delayTime; 
          if(delayTime < MIN_DELAY) {
              delayTime = MIN_DELAY; step = MAX_STEP;
              speedUp = false;
          }
      }else{
          --step; --step; 
          if(step < MIN_STEP) step = MIN_STEP;
          ++delayTime;
          if(delayTime > MAX_DELAY) {
              delayTime = MAX_DELAY; step = MIN_STEP;
              speedUp = true;
          }
      }//if(speedUp
  }//mouseClicked
} // class gHanoi3 
