#include <uhd/utils/thread_priority.hpp>
#include <uhd/utils/safe_main.hpp>
#include <uhd/usrp/multi_usrp.hpp>

#include <boost/program_options.hpp>
#include <boost/format.hpp>
#include <boost/thread.hpp>
#include <iostream>
#include <complex>
#include <cmath>

#include <csignal>
#include <stdio.h>
#include <stdlib.h>
#include "single_tx.h"

namespace po = boost::program_options;

//System parameters 
double freq, gain, thres;
double inter;
double rate;

//USRP
uhd::usrp::multi_usrp::sptr usrp1, usrp2;
string usrp1_ip, usrp2_ip;

//TX/RX metadata
uhd::tx_metadata_t tx_md1, tx_md2;

//Buffer
gr_complex pkt1[MAX_PKT_LEN], pkt2[MAX_PKT_LEN];
gr_complex zeros[SYM_LEN];

//File
FILE *in1_file, *in2_file;
string in1_name, in2_name; 

//Evaluation
size_t r_cnt;
static bool stop_signal = false;

void init_usrp() {
	// TODO: add usrp2
	usrp1 = uhd::usrp::multi_usrp::make(usrp1_ip);
	usrp1->set_rx_rate(rate);
	usrp1->set_tx_rate(rate);

	usrp1->set_rx_freq(freq);
	usrp1->set_tx_freq(freq);

	usrp1->set_rx_gain(gain);
}

void sync_clock() {
	cout << "SYNC Clock" << endl;
	// TODO: add usrp2
	usrp1->set_clock_config(uhd::clock_config_t::external());
	usrp1->set_time_next_pps(uhd::time_spec_t(0.0));
}


void init_sys() {
	
	// Buffer initialize	
	memset(pkt1, 0, sizeof(pkt1));
	
	// TODO: put generated signal in pkt1
	while(sample_cnt < MAX_PKT_LEN) {
		pkt1[sample_cnt++] = (gr_complex)(rand()&255);
	}


	/*
	for( int i = 0; i < sample_cnt; i++ )
		printf("%3d: %.4lf %.4lf\n", i, pkt1[i].real(), pkt1[i].imag());
	*/


	// USRP setting
	rate = 1e8/inter;
	freq = 1e9*freq;

	init_usrp();
	sync_clock();
}

void sig_int_handler(int){stop_signal = true;}



int UHD_SAFE_MAIN(int argc, char *argv[]){
	uhd::set_thread_priority_safe();
	uhd::time_spec_t refer;

	po::options_description desc("Allowed options");
	desc.add_options()
		("help", "help message")
		("r0", po::value<string>(&usrp1_ip)->default_value("addr=192.168.10.2"), "usrp's IP")
		("r1", po::value<string>(&usrp2_ip)->default_value("addr=192.168.20.2"), "usrp's IP")
		("in1", po::value<string>(&in1_name)->default_value("wcs_trace/tx1_signal.bin"), "binary samples file")
		("in2", po::value<string>(&in2_name)->default_value("wcs_trace/tx2_signal.bin"), "binary samples file")
		("i", po::value<double>(&inter)->default_value(SAMPLE_P), "interval of two sampling")
		("f", po::value<double>(&freq)->default_value(2.49), "RF center frequency in Hz")
		("g", po::value<double>(&gain)->default_value(30.0), "gain for the RF chain")
		("c", po::value<size_t>(&r_cnt)->default_value(90), "round count");

	po::variables_map vm;
	po::store(po::parse_command_line(argc, argv, desc), vm);
	po::notify(vm);

	if (vm.count("help")){
		cout << boost::format("UHD TX samples from file %s") % desc << endl;
		return ~0;
	}

	// Init
	init_sys();

	// Setup time
	boost::this_thread::sleep(boost::posix_time::milliseconds(WARM_UP_TIME));

	std::signal(SIGINT, &sig_int_handler);
	std::cout << "Press Ctrl + C to stop streaming..." << std::endl;

	//tx_md1.time_spec = usrp1->get_time_now() + uhd::time_spec_t(0, SYM_CNT*start, 1e8/inter);
	
	// TODO: add usrp2
	tx_md1.start_of_burst    = true;
	tx_md1.end_of_burst      = false;
	tx_md1.has_time_spec     = false;

	// TODO: add usrp2
	usrp1->get_device()->send(zeros, SYM_LEN, tx_md1, C_FLOAT32, S_ONE_PKT);

	// TODO: add usrp2
	tx_md1.start_of_burst    = false;
	tx_md1.end_of_burst		= false; 

	// Send Signals until press ^C
	// HINT: You have to send signals here
	// How many symbols you have to send? Ans: sym_cnt
	// pkt1: records the samples which we want to send
	
	// remove content of within while loop

	while(!stop_signal) {
		size_t sym_cnt = sample_cnt/SYM_LEN;
		size_t offset  = 0;
		for( size_t s = 0; s < sym_cnt; s++ ) {
			// printf("%3d: %.4lf %.4lf\n", offset, pkt1[offset].real(), pkt1[offset].imag());
			// printf("%3d: %.4lf %.4lf\n", offset+1, pkt1[offset+1].real(), pkt1[offset+1].imag());
			// TODO: add usrp2
			offset += usrp1->get_device()->send(pkt1+offset, SYM_LEN, tx_md1, C_FLOAT32, S_ONE_PKT);
		}
		//clean the buffer of USRP
		for(size_t j = 0; j < 20; j++) {
			// TODO: add usrp2
			usrp1->get_device()->send(zeros, SYM_LEN, tx_md1, C_FLOAT32, S_ONE_PKT);
		}
	}

	// TODO: add usrp2
	tx_md1.start_of_burst    = false;
	tx_md1.end_of_burst		= true; 
	
	usrp1->get_device()->send(zeros, SYM_LEN, tx_md1, C_FLOAT32, S_ONE_PKT);

    boost::this_thread::sleep(boost::posix_time::seconds(1));
	cout << "Terminate systems ... " << endl;
	return 0;
}
