#include <stdint.h>
#include <inttypes.h>
#include <x264.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <sys/time.h>
#include <string.h>

#define min(a,b) (a) >= (b) ? (b) : (a) 
#define SLOT 41667

const char src_path[] = "sample.yuv";
//const char dst_path[] = "output.h264";
const int weight = 1280;
const int height = 720;


class ENCODER {
  int y_size, frame_num;
  FILE *fp_src, *fp_dst;
  
  x264_picture_t* pPic_in, *pPic_out;
  x264_param_t* pParam;
  x264_t* pHandler; 
  x264_nal_t* pNals;

public:
  void init(const char*, int, int, int);
  void encode();
};

/* Get YUV information from arguments */
void ENCODER::init(const char* src, int width, int height, int csp){
  
  /*  allocate x264 memory */
  pPic_in = (x264_picture_t*)malloc(sizeof(x264_picture_t));
  pPic_out = (x264_picture_t*)malloc(sizeof(x264_picture_t));
  pParam = (x264_param_t*)malloc(sizeof(x264_param_t));

  /* open file */
  fp_src = fopen(src, "rb");
  fp_dst = fopen("sample.h264", "wb");

  /* default x264 params */
  x264_param_default(pParam);
  pParam->i_width = width;
  pParam->i_height = height;
  pParam->i_csp = csp;
  
  // must initial with it, or can not reconfig the rate
  pParam->rc.i_bitrate = 2048;
  pParam->rc.i_vbv_buffer_size = 2048;
  pParam->rc.i_vbv_max_bitrate = 2048;

  pParam->i_threads = 4;
  if (x264_param_apply_profile(pParam, "High" ) < 0)
    fprintf(stderr, "x264 param apply failed!\n");

  pHandler = x264_encoder_open(pParam);

  x264_picture_init(pPic_out);
  x264_picture_alloc(pPic_in, pParam->i_csp, pParam->i_width, pParam->i_height);

  y_size = pParam->i_width * pParam->i_height;
  
  fseek(fp_src, 0, SEEK_END);
  frame_num = ftell(fp_src)/(y_size*3/2);
  fseek(fp_src, 0, SEEK_SET);  

}

void ENCODER::encode(){
  int iNal;
   
  fprintf(stderr, "Frame_num: %u\n", frame_num);
  struct timeval start_time, current_time, result_time, last_time;

  gettimeofday(&start_time, NULL);
  gettimeofday(&last_time, NULL);
  for (int i=0;i<frame_num;i++){
        
    fread(pPic_in->img.plane[0], y_size, 1, fp_src);    //Y
    fread(pPic_in->img.plane[1], y_size>>2, 1, fp_src);  //U
    fread(pPic_in->img.plane[2], y_size>>2, 1, fp_src);  //V

    pPic_in->i_pts = i;
    
    //using following code to reconfig compression rate
    /*if ( i == 100 ){
	pParam->rc.i_bitrate = 1000;
  	pParam->rc.i_vbv_buffer_size = 1000;
  	pParam->rc.i_vbv_max_bitrate = 1000;
        x264_encoder_reconfig(pHandler, pParam);
    }*/
	 
    if (x264_encoder_encode(pHandler, &pNals, &iNal, pPic_in, pPic_out) < 0){
      fprintf(stderr, "encode failed at %d frame!\n", i);
      return;
    }
    for (int j = 0 ; j < iNal; j++){ 
      fwrite(pNals[j].p_payload, pNals[j].i_payload, 1, fp_dst);

    }
    
  }

  //flush encoder
  int cnt = 0, flushed = 0;
  while (1){
    if (x264_encoder_encode(pHandler, &pNals, &iNal, NULL, pPic_out) ==0)
      break; 
    flushed ++;
    for (int j = 0; j < iNal; j++){
      fwrite(pNals[j].p_payload, pNals[j].i_payload, 1, fp_dst);
    }
  }
  
  fprintf(stderr, "flushed: %d\n", flushed);
  x264_picture_clean(pPic_in);
  x264_encoder_close(pHandler);

  free(pPic_in);
  free(pPic_out);
  free(pParam);
  
  fclose(fp_dst);
  fclose(fp_src);

}

int main(int argc, char** argv){
  
  ENCODER encoder;
  encoder.init(src_path, weight, height, X264_CSP_I420);
  encoder.encode(); 
}
