
#ifndef u_kernel_h_
#define u_kernel_h_

/* Xilinx includes */
#include <stdio.h>
#include "stdlib.h"
#include <pvr.h>
#include <fsl.h>
#include <xparameters.h>
#include <mb_interface.h>

#define NUM_CORES 4
#define MASTER_CPU_SYNC_MAGIC_CODE 	31628
#define SLAVE_CPU_SYNC_MAGIC_CODE 	54766
#define KERNEL_TABLE_ADDR (XPAR_KERNEL_BRAM_IF_CNTLR_BASEADDR)

/* local memory size */
#define configTOTAL_LM_SIZE 50*1024
#define portBYTE_ALIGNMENT 4
#if portBYTE_ALIGNMENT == 4
	#define portBYTE_ALIGNMENT_MASK	( 0x0003 )
#endif

//#define CLOCKS_PER_MICROSEC (83000000.0/83333333)
#define CLOCKS_PER_MICROSEC (83000.0/83333333)

#define KENEL_MEM_MUTEX_NUM   0

typedef void * (*fp) (size_t);


typedef struct
{
    volatile long bootSync;
    volatile void *applicationThreadPtr[NUM_CORES];
} kernelTable;



unsigned int getCurrentCoreID();
void enableCaches();
void disableCaches();
void sleep(unsigned long msec);
int mutex_lock(int mutex_num);
int mutex_unlock(int mutex_num);


unsigned int tmr_get_value(void);

void *smp_malloc(size_t xWantedSize);
void smp_free(void *pv);

void smp_sleep(volatile long count);

void lm_transfer(void* dst_addr, void* src_addr, int len);
int transfer_status(void);

void vPortFree( void *pv );
void *lm_alloc( size_t xWantedSize );
size_t xPortGetFreeLocalMemSize( void );


#endif

