/*
 * stack_init.S
 *
 *  Created on: 2013/9/4
 *
 *      For microbaze 1~3 to initialize stack space to ddr2_sdram
 */

.extern main_stack
.extern AppThreadPtr



.global stack_init
.section .text
.align 4
.ent vPortStartFirstTask
.type vPortStartFirstTask, @function
stack_init:

	mfs			r18,	rpvr0					/* Get the contents of the PVR register */
	andi		r18,	r18,	0xFF			/* Put the value of the high byte (the USER1/CPU ID information) in r18 */
	muli		r18,	r18,	4				/* Find the relative address of a word for the current CPU */
	lwi			r1,		r18,	main_stack	    /* load the current CPU's stack pointer */
	lwi			r15,	r18,	AppThreadPtr
	nop


    rtsd		r15,	0
    nop
.end vPortStartFirstTask
