#ifndef DEC_TEST_H
#define DEC_TEST_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "avcdec_api.h"
#include "avcdec_int.h"

#include "avcdec_lib.h"

#include "../u_kernel.h"


typedef unsigned char uint8_t;

#ifndef false
    #define false 0
#endif

#ifndef true
    #define true 1
#endif

/* dump file */
//#define dumpFile

#define INPUT_FILE_NAME "a:\\qp32.264"
#define OUTPUT_FILE_NAME "out.yuv"

static const char kStartCode[4] = { 0x00, 0x00, 0x00, 0x01 };

void AVCDecInit(AVCHandle * Handle,int *SPSSeen,int *PPSSeen,int * h264_offset);
int DecNALUnit (AVCHandle *mHandle,const uint8_t *NALUnit,const int NALSize,int *mSPSSeen,int *mPPSSeen);
int ReadNALUnit(const uint8_t * H264_File , int H264_Offset ,int H264_Size ,const uint8_t ** NALUnit ,int *NALSize );

int waveFront();

//int thr_decode_one_row(int arg);
int thr_decode_one_row(int arg);
int main_thread_one_row(int arg);

int checkNeighborMB(int mbAddrB,int mbAddrC,uint mbAvailB,uint mbAvailC);

#define THREAD_COUNT 3

extern int* enable_thr;

extern volatile int tick_cnt;
extern volatile int* local_cnt;

#define BR_FLAG_ADDR 0x84410a00
#define PBR_MB_FLAG_ADDR 0x84410100

extern uint8 **intra_pred_top;
extern uint8 **intra_pred_top_cb;
extern uint8 **intra_pred_top_cr;

/* mutex */
#ifndef KENEL_MEM_MUTEX_NUM
#define CORE0_MUTEX_NUM 0
#endif
#ifndef APP_MUTEX_NUM
#define APP_MUTEX_NUM 1
#endif
#ifndef SYN_MUTEX_NUM
#define SYN_MUTEX_NUM 2
#endif


/* row mutex */
#define ROW_MUTEX_BASE 5
/* QCIF : 9, CIF : 18 , SD : 30 */
#define ROW_MUTEX_LENGTH 18

/* CIF : 396 , SD : 1350 */
#define ALL_MBS_NUM 396


//#define INITIAL_MUTEX 8

int core_mutex_id[THREAD_COUNT];


#endif
