#ifndef DEC_TEST_H
#define DEC_TEST_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "avcdec_api.h"
#include "avcdec_int.h"

#include"../u_kernel.h"

typedef unsigned char uint8_t;

#ifndef false
    #define false 0
#endif

#ifndef true
    #define true 1
#endif

extern volatile int* tick_cnt;


static const char kStartCode[4] = { 0x00, 0x00, 0x00, 0x01 };

void AVCDecInit(AVCHandle * Handle,int *SPSSeen,int *PPSSeen,int * h264_offset);
int DecNALUnit (AVCHandle *mHandle,const uint8_t *NALUnit,const int NALSize,int *mSPSSeen,int *mPPSSeen);
int ReadNALUnit(const uint8_t * H264_File , int H264_Offset ,int H264_Size ,const uint8_t ** NALUnit ,int *NALSize );

int single_core();

//#define dumpFile

#define INPUT_FILE_NAME "a:\\qp32.264"
#define OUTPUT_FILE_NAME "out.yuv"

#endif


