#ifndef DEC_TEST_H
#define DEC_TEST_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "avcdec_api.h"
#include "avcdec_int.h"
#include"avclib_common.h"
#include"avcdec_lib.h"

#include "../u_kernel.h"
#include "sysace_stdio.h"

typedef unsigned char uint8_t;

#ifndef false
    #define false 0
#endif

#ifndef true
    #define true 1
#endif

#ifndef APP_MUTEX_NUM
#define APP_MUTEX_NUM 10
#endif

/* mutex number */
#define NALBUF_MUTEX_NUM 1
#define SECBUF_MUTEX_NUM 2
#define THIRBUF_MUTEX_NUM 3
#define INITIAL_MUTEX 4
#define BUFFINIT_MUTEX 5
//#define DEBLOCK_PART_MUTEX 6
#define NAL_COUNT_MUTEX 5



static const char kStartCode[4] = { 0x00, 0x00, 0x00, 0x01 };

void AVCDecInit(AVCHandle * Handle,int *SPSSeen,int *PPSSeen,int * h264_offset);
int DecNALUnit (AVCHandle *mHandle,const uint8_t *NALUnit,const int NALSize,int *mSPSSeen,int *mPPSSeen);
int ReadNALUnit(const uint8_t * H264_File , int H264_Offset ,int H264_Size ,const uint8_t ** NALUnit ,int *NALSize );
AVCDec_Status FlushDataToConsumer(AVCHandle *avcHandle, uint8 *buffer,int buf_size);

int initAVCDecoder(void);


int producer();
int consumer();
int consumer_mc();
int consumer_deblock();

//#define dumpFile

#define INPUT_FILE_NAME "a:\\qp32.264"
#define OUTPUT_FILE_NAME "out.yuv"

#define BUF_DEPTH 17
int* localMemAddr_fir[BUF_DEPTH];
int* localMemAddr_sec[BUF_DEPTH];

/* QCIF = 11 , CIF = 22 , SD = 45*/
#define PICWIDTHINMBS 22

#ifndef USE_PRED_BLOCK
#define USE_PRED_BLOCK
#endif

//#define BUF_SIZE 4*1024

/* block ram base address for global variable ( flag ) */
#define BLOCK_RAM_BASE_ADDR 0x84410800L

typedef struct {
	int nal_size;
	int nalType;
	uint8_t* ptr;
}InputBuf;

typedef struct {
	InputBuf buf[BUF_DEPTH];
	volatile int *m_rear;
    volatile int *m_front;
	int mutex;
}ringBuffer;


typedef struct{
	AVCCommonObj* ptr;
}secInputBuf;

typedef struct {
	secInputBuf buf[BUF_DEPTH];
	volatile int *m_rear;
	volatile int *m_front;
	int mutex;
}secRingBuffer;

typedef struct {
	AVCCommonObj* ptr;
}thirInputBuf;

typedef struct {
	thirInputBuf buf[BUF_DEPTH];
	volatile int *m_rear;
	volatile int *m_front;
	int mutex;
}thirRingBuffer;


#endif

