;
; This is a machine program that computes 3*3 + 4*4 - 5*5 and saves
; the result in memory cell 00. Note that 3*3 = 3*4-3 and 5*5 = 5*4+5
;
       load R5, 252        ; load a bit mask to R5
       load R6, 255        ; FF will be used to compute 1's complement

       load R0, 3         ; R0 has 3
       ror  R0, 6         ; Rotate R0 6 bits to the right
       and  R0, R0, R5    ; Now R0 has 3*4
       load R7, -3        ; -3 in 2's complement notation is FD
       addi R0, R0, R7    ; Now R0 has 3*3

       load R1, 4         ; R1 has 4
       ror  R1, 6         ; Rotate R1 6 bits to the right
       and  R1, R1, R5    ; Now R1 has 4*4

       load R2, 5         ; R2 has 5
       ror  R2, 6         ; Rotate R2 6 bits to the right
       and  R2, R2, R5    ; Now R2 has 5*4
       load R7, 5
       addi R2, R2, R7    ; Now R2 has 5*5
; take 2's complement of R2
       xor  R2, R2, R6
       load R7, 1
       addi R2, R2, R7    ; Now R2 has -5*5

; compute 3*3 + 4*4 - 5*5
       addi R3, R0, R1
       addi R0, R2, R3    ; We should have 0 in R0
       store R0, [$40]
       halt
