/* ///////////////////////////////////////////////////////////////  */
/*  Program : main.c                                                */
/* ---------------------------------------------------------------  */
/*  This is a set of sample C files for the UML diagram homework.   */
/*                                                                  */
/*  The program is written for the class "Introduction to Computer  */
/*  Science" by Hung-Cheng Su on 04/30/2012.                        */
/* //////////////////////////////////////////////////////////////// */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "main.h"
#include "sort.h"
#include "tool.h"

void object_init(struct NameList *name, struct NumberList *number)
{
    int     i;

    name->mList.size = 10;
    name->mList.cmp = &cmp_char;
    name->mList.swap = &swap_char;

    name->data = (char **) malloc(name->mList.size * sizeof(char *));
    for (i = 0; i < name->mList.size; i++)
    {
        *(name->data + i) = (char *) malloc(32 * sizeof(char));
    }
    strcpy(*(name->data + 0), "Jax");
    strcpy(*(name->data + 1), "Olaf");
    strcpy(*(name->data + 2), "Sona");
    strcpy(*(name->data + 3), "Pantheon");
    strcpy(*(name->data + 4), "Lux");
    strcpy(*(name->data + 5), "Janna");
    strcpy(*(name->data + 6), "Soraka");
    strcpy(*(name->data + 7), "Vayne");
    strcpy(*(name->data + 8), "Wukong");
    strcpy(*(name->data + 9), "Corki");
    name->mList.data = name->data; /* duplicates data pointer so that mList */
                                   /* can be used as a generic List object  */
    number->mList.size = 10;
    number->mList.cmp = &cmp_int;
    number->mList.swap = &swap_int;

    number->data = malloc(number->mList.size * sizeof(long));
    *(number->data + 0) = 3;
    *(number->data + 1) = -34;
    *(number->data + 2) = 65;
    *(number->data + 3) = 11;
    *(number->data + 4) = 97;
    *(number->data + 5) = 51;
    *(number->data + 6) = 83;
    *(number->data + 7) = -78;
    *(number->data + 8) = -100;
    *(number->data + 9) = 4;
    number->mList.data = number->data;
}

void object_delete(struct NameList *name, struct NumberList *number)
{
    int i;

    for (i = 0; i < name->mList.size; i++)
    {
        free(*(name->data + i));
    }
    free(name->data);
    free(number->data);
}

void object_display(struct NameList *name, struct NumberList *number)
{
    int i;

    printf("NameList data: \n");
    for (i = 0; i < name->mList.size; i++)
    {
        printf("  %s", name->data[i]);
    }

    printf("\nNumberList data: \n");
    for (i = 0; i < number->mList.size; i++)
    {
        printf("  %ld", number->data[i]);
    }
    
    printf("\n");
}

int main()
{
    struct NameList mNameList;
    struct NumberList mNumberList;
    int     res;
    char   *key_char = "Vayne";
    long    key_num = 3;

    object_init(&mNameList, &mNumberList);

    printf("\nInitial lists:\n");
    object_display(&mNameList, &mNumberList);

    bubble_sort(&mNameList.mList);
    bubble_sort(&mNumberList.mList);

    printf("\nSorted lists:\n");
    object_display(&mNameList, &mNumberList);

    printf("\nSearch NameList with the key \"%s\"\n", key_char);
    res = binary_search(&mNameList.mList, (void *) &key_char, 0,
                        mNameList.mList.size-1);
    if (res != -1)
    {
        printf("found! at %d \n", res);
    }
    else
    {
        printf("not found \n");
    }

    printf("\nSearch NumberList with the key \"%ld\"\n", key_num);
    res = binary_search(&mNumberList.mList, (void *) &key_num, 0,
                        mNumberList.mList.size-1);
    if (res != -1)
    {
        printf("found! at %d \n", res);
    }
    else
    {
        printf("not found \n");
    }

    object_delete(&mNameList, &mNumberList);

    return 0;
};
