package dice_war;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.BevelBorder;
import javax.swing.border.SoftBevelBorder;

import java.net.*;
import java.util.ArrayList;
import java.io.*;
import java.util.*;
/**
 * User's Interface, get the input of the user by UserInterface and get the input of the server by NetReceiver, 
 * then display the result on BattleField
 */
public class UserInterface extends javax.swing.JPanel implements ActionListener
{
	private static final long serialVersionUID = 1L;
	private JTabbedPane jTabbedPane1;
	private JPanel history;
	private JPanel setting;
	private JPanel battleField;
	private JList operatorList;
	private JButton changeOperator;
	private JButton lookAndFeel;
	private JList lookAndFeelList;
	private JTextField port;
	private JLabel jLabel6;
	private JPanel jPanel2;
	private JTextField serverIP;
	private JLabel jLabel5;
	private JPanel jPanel1;
	private JButton connect;

	/**
	 * Auto-generated main method to display this JPanel inside a new JFrame.
	 */
	public static void main(String[] args)
	{
		JFrame frame = new JFrame();
		UserInterface ui = new UserInterface();
		// TODO: remove this line
		ui.selfCountry = 1;

		frame.setTitle("Wow!Dice War!! v0.6 (Client)");
		frame.getContentPane().add(ui);
		frame.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		frame.pack();
		frame.setResizable(false);
		frame.setVisible(true);

		// Map map = new Map(12, 8, 8, 70);
		// map.generateMap();
		// ui.startDW(map);
		ui.startDW();
	}

	UserInterface()
	{
		super();
		AIList = readAIClass();
		operators = loadAIClass();
//		System.out.println(AIList);
		initGUI();
	}
	// the AI's format is the class in package dice_war.AI and is extended AITemplate
	private AITemplate[] loadAIClass()
	{
		AITemplate[] ait = new AITemplate[AIList.length];
		ait[0] = null; // human
		for (int i = 1; i < ait.length; i++) {
			Class c;
			try {
				c = Class.forName("dice_war.AI." + AIList[i]);
				ait[i] = (AITemplate) c.newInstance();
			} catch (Exception e) {
				ait[i] = null;
				e.printStackTrace();
			}
		}
		return ait;
	}

	private String[] readAIClass()
	{
		String[] ret = new String[] { "Human" };

		File fr = new File("dice_war/AI");
		ArrayList al = new ArrayList();
		String[] list = fr.list();
		if (list != null) {
			for (int i = 0; i < list.length; i++) {
				String[] ss = list[i].split("\\.");
				if (ss[0].equals("AIToolkit"))
					continue;
				if (ss.length == 2 && ss[1].toLowerCase().equals("class")) {
					try {
						Class c = Class.forName("dice_war.AI." + ss[0]);
						Object obj = c.newInstance();
						if (obj instanceof AITemplate)
							al.add(ss[0]);
					} catch (Exception e) {
						System.err.println("[client] cannot load AI: dice_war.AI." + ss[0]);
						e.printStackTrace();
					}
				}
			}
		}
		if (al.size() > 0) {
			ret = new String[al.size() + 1];
			ret[0] = "Human";
			for (int i = 1; i < ret.length; i++)
				ret[i] = (String) al.get(i - 1);
		}

		return ret;
	}

	static final String[] lookAndFeels = new String[] {
			"javax.swing.plaf.metal.MetalLookAndFeel",
			"com.birosoft.liquid.LiquidLookAndFeel",
			"com.sun.java.swing.plaf.windows.WindowsLookAndFeel",
	};

	String[] AIList;

	private void initGUI()
	{
		try {
			// System.out.println(UIManager.getLookAndFeel());
			// UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
			BorderLayout thisLayout = new BorderLayout();
			this.setLayout(thisLayout);
			this.setPreferredSize(new java.awt.Dimension(800, 600));
			{
				jTabbedPane1 = new JTabbedPane();
				this.add(jTabbedPane1, BorderLayout.CENTER);
				jTabbedPane1.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
				{
					battleField = new BattleField();
					jTabbedPane1
							.addTab("Battle Field", null, battleField, null);
				}
				{
					history = new JPanel();
					jTabbedPane1.addTab("History", null, history, null);
				}
				{
					setting = new JPanel();
					GridBagLayout settingLayout = new GridBagLayout();
					settingLayout.columnWeights = new double[] { 0.1, 0.1, 0.1,
							0.1, 0.1 };
					settingLayout.columnWidths = new int[] { 7, 7, 7, 7, 7 };
					settingLayout.rowWeights = new double[] { 0.1, 0.1, 0.1,
							0.1, 0.1 };
					settingLayout.rowHeights = new int[] { 7, 7, 7, 7, 7 };
					setting.setLayout(settingLayout);
					jTabbedPane1.addTab("Setting", null, setting, null);
					{
						connect = new JButton();
						setting.add(connect, new GridBagConstraints(0, 0, 1, 1,
								0.0, 0.0, GridBagConstraints.CENTER,
								GridBagConstraints.NONE,
								new Insets(0, 0, 0, 0), 0, 0));
						connect.setText("Connect");
						connect.addActionListener(this);
					}
					{
						jPanel1 = new JPanel();
						setting.add(jPanel1, new GridBagConstraints(1, 0, 1, 1,
								0.0, 0.0, GridBagConstraints.CENTER,
								GridBagConstraints.HORIZONTAL, new Insets(0, 0,
										0, 0), 0, 0));
						BorderLayout jPanel1Layout3 = new BorderLayout();
						jPanel1.setLayout(jPanel1Layout3);
						{
							jLabel5 = new JLabel();
							jPanel1.add(jLabel5, BorderLayout.WEST);
							jLabel5.setText("Server Name");
						}
						{
							serverIP = new JTextField();
							jPanel1.add(serverIP, BorderLayout.CENTER);
							serverIP.setText("127.0.0.1");
						}
					}
					{
						jPanel2 = new JPanel();
						setting.add(jPanel2, new GridBagConstraints(2, 0, 1, 1,
								0.0, 0.0, GridBagConstraints.CENTER,
								GridBagConstraints.HORIZONTAL, new Insets(0, 0,
										0, 0), 0, 0));
						BorderLayout jPanel2Layout = new BorderLayout();
						jPanel2.setLayout(jPanel2Layout);
						{
							jLabel6 = new JLabel();
							jPanel2.add(jLabel6, BorderLayout.WEST);
							jLabel6.setText("Port");
						}
						{
							port = new JTextField();
							jPanel2.add(port, BorderLayout.CENTER);
							port.setText("2046");
						}
					}
					{
						ListModel jList1Model = new DefaultComboBoxModel(
								new String[] { "MetalLookAndFeel",
										"LiquidLookAndFeel",
										"WindowsLookAndFeel",
								});
						lookAndFeelList = new JList();
						setting.add(lookAndFeelList, new GridBagConstraints(1,
								3, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER,
								GridBagConstraints.HORIZONTAL, new Insets(0, 0,
										0, 0), 0, 0));
						lookAndFeelList.setModel(jList1Model);
						lookAndFeelList.setBorder(new SoftBevelBorder(
								BevelBorder.LOWERED, null, null, null, null));
					}
					{
						lookAndFeel = new JButton();
						setting.add(lookAndFeel, new GridBagConstraints(0, 3,
								1, 1, 0.0, 0.0, GridBagConstraints.CENTER,
								GridBagConstraints.NONE,
								new Insets(0, 0, 0, 0), 0, 0));
						lookAndFeel.setText("Change the Look & Feel");
						lookAndFeel.addActionListener(this);
					}
					{
						changeOperator = new JButton();
						setting.add(changeOperator, new GridBagConstraints(0,
								2, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER,
								GridBagConstraints.NONE,
								new Insets(0, 0, 0, 0), 0, 0));
						changeOperator.setText("Change Operator");
						changeOperator.addActionListener(this);
					}
					{
						ListModel operatorListModel = new DefaultComboBoxModel(
								AIList);
						operatorList = new JList();
						setting.add(operatorList, new GridBagConstraints(1, 2,
								1, 1, 0.0, 0.0, GridBagConstraints.CENTER,
								GridBagConstraints.BOTH,
								new Insets(0, 0, 0, 0), 0, 0));
						operatorList.setModel(operatorListModel);
						operatorList.setSelectedIndex(0);
						operatorList.setBorder(new SoftBevelBorder(
								BevelBorder.LOWERED, null, null, null, null));
					}
				}
			}
			// jTabbedPane1.setBackgroundAt(0, new Color(0, 0, 255));
			// jTabbedPane1.setBackgroundAt(0, new Color(128, 64, 255));
			// jTabbedPane1.setBackgroundAt(1, new Color(128, 64, 255));
			// jTabbedPane1.setBackgroundAt(2, new Color(128, 64, 255));
			// debug
			jTabbedPane1.setSelectedIndex(2);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	int selfCountry;
	int turn;
	int operator;
	AITemplate operators[];
	Map map;

	void startDW()
	{
		this.updateUI();
	}

	private void repaintAll()
	{
		repaint();
	}

	// boolean[] bUpdatedNodes;
	/*
	 * for display updated info
	 */
	int updatedNodesDifference[];

	LinkedList updatedNodesQueue;

	/**
	 * Handle user's input, i.e. the mouse click and some buttons.
	 * Draw the map and info.
	 */
	class BattleField extends JPanel implements MouseListener, ActionListener

	{
		private static final long serialVersionUID = 1L;

		static final int BASE_X = -50;
		static final int BASE_Y = -40;
		static final int RADIUS = 15;
		static final int RADIUS_OUT = 30;
		static final int INFO_TOP_Y = 485;
		static final int END_TURN_X = BASE_X + RADIUS_OUT * 25 + 10;
		static final int END_TURN_Y = BASE_Y + RADIUS_OUT * 2;

		Color[] colors = new Color[] { Color.WHITE, new Color(255, 80, 64),
				Color.GREEN, new Color(96, 96, 255), Color.PINK, Color.YELLOW,
				Color.CYAN, Color.MAGENTA, Color.ORANGE };

		JButton endTurn;
		JButton endArrangement;
		Font font;
		Font newNodeFont;
		int nNewDice;

		BattleField()
		{
			font = new Font("Arial", Font.BOLD, 20);
			newNodeFont = new Font("Arial", Font.BOLD, 14);
			this.addMouseListener(this);

			this.setLayout(null);
			endTurn = new JButton("End Turn");
			this.add(endTurn);
			endTurn.setFont(new Font("", Font.BOLD, 12));
			endTurn.setSize(endTurn.getPreferredSize());
			endTurn.setLocation(END_TURN_X, END_TURN_Y);
			endTurn.addActionListener(this);

			endArrangement = new JButton("End Arrangement");
			this.add(endArrangement);
			endArrangement.setFont(new Font("", Font.BOLD, 12));
			endArrangement.setSize(endTurn.getPreferredSize());
//			endArrangement.setSize(endTurn.getPreferredSize().width*2, 
//									endTurn.getPreferredSize().height);
			endArrangement.setLocation(END_TURN_X, END_TURN_Y + 50);
			endArrangement.addActionListener(this);
		}

		public void paintComponent(Graphics g)
		{
			if (map == null)
				return;

			Node[] nodes = map.nodes;
			// draw edges
			g.setColor(Color.BLACK);
			boolean edge[][] = map.edge;
			for (int i = 0; i < edge.length; i++) {
				if (nodes[i].country == 0)
					continue;
				for (int j = i + 1; j < edge[i].length; j++) {
					if (nodes[j].country == 0)
						continue;
					if (edge[i][j]) {
						int fx = BASE_X + nodes[i].x * RADIUS_OUT * 2 + RADIUS;
						int fy = BASE_Y + nodes[i].y * RADIUS_OUT * 2 + RADIUS;
						int tx = BASE_X + nodes[j].x * RADIUS_OUT * 2 + RADIUS;
						int ty = BASE_Y + nodes[j].y * RADIUS_OUT * 2 + RADIUS;
						// revise the length of edge
						int gap;
						if (fx == tx || fy == ty) { // straight line
							gap = RADIUS;
						} else {
							gap = (int) (RADIUS / Math.sqrt(2));
						}
						if (fx < tx) {
							fx += gap;
							tx -= gap;
						} else if (fx > tx) {
							fx -= gap;
							tx += gap;
						}
						if (fy < ty) {
							fy += gap;
							ty -= gap;
						} else if (fy > ty) {
							fy -= gap;
							ty += gap;
						}
						g.drawLine(fx, fy, tx, ty);
					}
				}
			}
			// draw nodes
			for (int i = 0; i < nodes.length; i++) {
				if (nodes[i].country == 0)
					continue;
				drawNode(g, nodes, i, colors[nodes[i].country], Color.DARK_GRAY);
			}
			// draw info
			g.setColor(Color.BLUE);
			g.drawLine(0, INFO_TOP_Y, 800, INFO_TOP_Y);
			g.drawLine(0, INFO_TOP_Y + 1, 800, INFO_TOP_Y + 1);
			g.setColor(Color.WHITE);
			g.drawLine(0, INFO_TOP_Y + 2, 800, INFO_TOP_Y + 2);
			g.drawLine(0, INFO_TOP_Y + 3, 800, INFO_TOP_Y + 3);
			g.setColor(new Color(16, 32, 128));
			g.fillRect(0, INFO_TOP_Y + 4, 800, 600);

			for (int i = 1; i < map.maxConnectedCount.length; i++) {
				int x = i * 50;
				int y = INFO_TOP_Y + 20;
				g.setColor(colors[i]);
				g.drawRoundRect(x, y, 30, 30, 5, 5);
				g.drawRoundRect(x + 1, y + 1, 30 - 2, 30 - 2, 3, 3);
				g.setFont(font);
				g.drawString("" + map.maxConnectedCount[i], x + 5, y + 22);
				if (i == selfCountry) {
					g.drawString("(me)", x - 5, y + 52);
				}
				if (turn == i) {
					g.setColor(Color.WHITE);
					g.fillRoundRect(x - 2, y - 10, 30 + 4, 4, 6, 6);
				}
			}

			int x = END_TURN_X;
			int y = END_TURN_Y + 100;
			g.setColor(colors[selfCountry]);
			g.drawRoundRect(x, y, 30, 30, 5, 5);
			g.drawRoundRect(x + 1, y + 1, 30 - 2, 30 - 2, 3, 3);
			g.setFont(font);
			g.drawString("" + nNewDice, x + 5, y + 22);

			// draw selected
			if (attackFrom >= 0)
				drawNode(g, nodes, attackFrom, Color.BLACK, Color.RED);
			if (attackTo >= 0)
				drawNode(g, nodes, attackTo, Color.BLACK, Color.RED);
			// TODO: draw battle process
		}

		private int transposeX(int x)
		{
			return BASE_X + x * RADIUS_OUT * 2;
		}

		private int transposeY(int y)
		{
			return BASE_Y + y * RADIUS_OUT * 2;
		}

		private void drawNode(Graphics g, Node[] nodes, int i, Color inside,
				Color border)
		{
			int x = transposeX(nodes[i].x);
			int y = transposeY(nodes[i].y);
			g.setColor(inside);
			g.fillOval(x, y, RADIUS * 2, RADIUS * 2);
			g.setColor(border);
			g.drawOval(x, y, RADIUS * 2, RADIUS * 2);
			g.drawOval(x + 1, y, RADIUS * 2 - 2, RADIUS * 2);
			g.drawOval(x, y + 1, RADIUS * 2, RADIUS * 2 - 2);
			g.drawOval(x + 1, y + 1, RADIUS * 2 - 1, RADIUS * 2 - 1);
			g.setFont(font);
			g.drawString("" + nodes[i].number, x + RADIUS - 5, y + RADIUS + 7);

			int diff = updatedNodesDifference[i];
			String msg = "";
			if (diff > Map.MAX_DICE)
				msg = "NEW!";
			else if (diff > 0)
				msg = "+" + diff;
			else if (diff < 0)
				msg = "" + diff;
			g.setColor(Color.WHITE);
			g.setFont(newNodeFont);
			g.drawString(msg, x + RADIUS + 8, y + RADIUS - 8);
		}

		boolean isInside(int x, int y, int X, int Y, int R)
		{
			return ((x - X) * (x - X) + (y - Y) * (y - Y)) <= R * R;
		}

		static final int STATE_NO_SELECTION = 0;
		static final int STATE_FROM_SELECTED = 1;
		static final int STATE_TO_SELECTED = 2;
		static final int STATE_ARRANGEMENT = 3;

		int attackFrom = -1;

		int attackTo = -1;

		int state = STATE_NO_SELECTION;
		/**
		 * use a simple finite state machine to handle user's click
		 */
		public void mouseClicked(MouseEvent me)
		{
			if (turn != selfCountry || operator != 0)
				return;

			// find out which node is clicked
			int selected = -1;
			int x = me.getX();
			int y = me.getY();
			Node[] nodes = map.nodes;
			boolean[][] edge = map.edge;

			for (int i = 0; i < nodes.length; i++) {
				if (isInside(x, y, transposeX(nodes[i].x) + RADIUS,
						transposeY(nodes[i].y) + RADIUS, RADIUS)) {
					selected = i;
					break;
				}
			}
			if (selected == -1)
				return;

			if (state == STATE_NO_SELECTION) {
				if (nodes[selected].country != selfCountry
						|| nodes[selected].number <= 1)
					return;

				attackFrom = selected;
				attackTo = -1;
				state = STATE_FROM_SELECTED;
			} else if (state == STATE_FROM_SELECTED) {
				if (attackFrom == selected) { // deselected
					attackFrom = -1;
					state = STATE_NO_SELECTION;
				} else {
					if (nodes[selected].country == selfCountry
							|| edge[attackFrom][selected] == false)
						return;

					attackTo = selected;
					// state = STATE_TO_SELECTED;
					attack(attackFrom, attackTo);
					state = STATE_NO_SELECTION;
					attackFrom = attackTo = -1;
				}
			} else if (state == STATE_ARRANGEMENT) {
				if (nodes[selected].number < Map.MAX_DICE) {
					Message msg = new Message("append dice", new Integer(
							selected));
					agent.sendMessage(msg);
				}
			}
			repaintAll();
		}

		private void attack(int from, int to)
		{
			if (agent == null)
				return;

			Message msg = new Message("attack", new int[] { from, to });
			agent.sendMessage(msg);
		}

		public void mousePressed(MouseEvent arg0) {}
		public void mouseReleased(MouseEvent arg0) {}
		public void mouseEntered(MouseEvent arg0) {}
		public void mouseExited(MouseEvent arg0) {}
		
		public void actionPerformed(ActionEvent ae)
		{
			if (agent == null)
				return;

			if (ae.getSource().equals(endTurn)) {
				Message msg = new Message("end turn", null);
				agent.sendMessage(msg);
			} else {
				Message msg = new Message("end my arrangement", null);
				agent.sendMessage(msg);
			}
		}

		public void setState(int ns)
		{
			state = ns;
			attackFrom = attackTo = -1;
		}
	}

	public void actionPerformed(ActionEvent ae)
	{
		if (ae.getSource().equals(connect)) {
			String context = "connect to server successful";
			int type = JOptionPane.INFORMATION_MESSAGE;
			if (connect(serverIP.getText(), port.getText()) == false) {
				context = "cannot connect to server";
				type = JOptionPane.ERROR_MESSAGE;
			}
			popUpMessageWindow("connect to server", context, type);
			jTabbedPane1.setSelectedIndex(0);
			repaintAll();
		} else if (ae.getSource().equals(lookAndFeel)) {
			try {
				int index = lookAndFeelList.getSelectedIndex();
//				System.out.println(index);
				UIManager.setLookAndFeel(lookAndFeels[index]);
				SwingUtilities.updateComponentTreeUI(this);
			} catch (Exception e) {
				e.printStackTrace();
			}
		} else if (ae.getSource().equals(changeOperator)) {
			String title = "Change Operator";
			String context;
			int type;
			if (turn == selfCountry) {
				context = "You cannot change operator when it's your turn";
				type = JOptionPane.ERROR_MESSAGE;
			} else {
				operator = operatorList.getSelectedIndex();
				context = operatorList.getSelectedValue() + " plays now!";
				type = JOptionPane.INFORMATION_MESSAGE;
			}
			popUpMessageWindow(title, context, type);
		}
	}

	Socket socket;
	/**
	 * connect to server, the first step
	 * @param ip the IP of the server
	 * @param port the port of the server
	 * @return true if connection is builded, otherwise false
	 */
	boolean connect(String ip, String port)
	{
		System.out.println("[ start connecting ... ]");
		/*
		 * init network connection
		 */
		if (socket != null) {
			try {
				if (socket.isClosed() == false)
					socket.close();
			} catch (IOException e2) {
				e2.printStackTrace();
				return false;
			} catch (Exception e) {
				e.printStackTrace();
				return false;
			}
			socket = null;
		}
		try {
			// init I/O
			socket = new Socket(ip, Integer.parseInt(port));
			agent = new Agent(socket);

			// init threads
			NetReceiver na = new NetReceiver();

			Thread threadNa = new Thread(na);
			threadNa.start();
		} catch (Exception e) {
			if (socket == null) {
				String context = ip + ":" + port + " is unreachable";
				popUpMessageWindow("can't connect to server", context, JOptionPane.ERROR_MESSAGE);
			} else {
				System.out.println("unknown error");
				e.printStackTrace();
			}
			return false;
		}
		// network connection success
		/*
		 * setup environment data
		 */
		for (int i=1; i<operators.length; i++) {
			operators[i].reset();
		}
		return true;
	}

	void popUpMessageWindow(String title, String context, int type)
	{
		JOptionPane.showConfirmDialog(this, context, title,
				JOptionPane.DEFAULT_OPTION, type);
	}

	Agent agent;

	boolean bRun;
	/**
	 * A thread waiting for server's messages
	 */
	class NetReceiver implements Runnable
	{
		public void run()
		{
			if (agent == null)
				return;
			
			Message msg;
			bRun = true;
			while (bRun) {
				msg = agent.readMessage();
				// System.out.println("recv msg: " + msg);
				if (msg == null) {
					break;
				}
				
				if (msg.cmd.equals("set map")) {
					System.out.println("[client] get the map");
					map = (Map)msg.arg;

					updatedNodesDifference = new int[map.nodes.length];
					updatedNodesQueue = new LinkedList();
					try {
						Thread.sleep(500);
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
				} else if (msg.cmd.equals("update map")) {
					Node[] u = (Node[])msg.arg;
					if (u != null) {
						for (int i=0; i<u.length; i++) {
							// record updated info
							Node old = map.nodes[u[i].index];
							if (u[i].country == old.country) {
								updatedNodesDifference[u[i].index] = u[i].number - old.number;
								// check if it's arrange new dices, if yes,
								// decrease nNewDice (the display info)
								BattleField bf = (BattleField)battleField;
								if (bf.state == BattleField.STATE_ARRANGEMENT && u[i].number == old.number+1)
									bf.nNewDice--;
									
							} else 
								updatedNodesDifference[u[i].index] = Map.MAX_DICE * 2;
							// clear old info
							if (updatedNodesQueue.contains(old))
								updatedNodesQueue.remove(old);
							updatedNodesQueue.add(u[i]);
							if (updatedNodesQueue.size() > 10) {
								Node n = (Node)updatedNodesQueue.removeFirst();
								updatedNodesDifference[n.index] = 0;
							}
							// update map and operator's map (for AI)
							map.nodes[u[i].index].copyValue(u[i]);
							if (operator != 0 && operators != null && operators[operator] != null && operators[operator].nodes != null)
								synchronized (operators[operator].nodes) {
									operators[operator].nodes[u[i].index].copyValue(u[i]);
								}
						}
					}
				} else if (msg.cmd.equals("set country")) {
					Integer n = (Integer)msg.arg;
					selfCountry = n.intValue();
				} else if (msg.cmd.equals("set turn")) {
					Integer n = (Integer)msg.arg;
					turn = n.intValue();	   			
					if (turn == selfCountry) { 
						if (operator == 0) {
							popUpMessageWindow("set turn", "It's your turn!", JOptionPane.INFORMATION_MESSAGE);
						} else {  // let AI operate it
							if (operators != null && operators[operator] != null && operators[operator].bRun == false)
								operators[operator].process(map, agent, selfCountry);
							else
								operator = 0;
						}
					}
				} else if (msg.cmd.equals("update count of connected nodes")) {
					int[] ccn = (int[])msg.arg;
					if (map != null)
						map.maxConnectedCount = ccn;
				} else if (msg.cmd.equals("arrange new dices")) {
					int n = ((Integer)msg.arg).intValue();
//					System.out.println("New dices to arrange: " + n);
					if (turn == selfCountry && operator != 0) { // let AI operate it
						if (operators != null && operators[operator] != null)
							operators[operator].processArrangeNewDice(map, agent, selfCountry, n);
						else
							operator = 0;
					} else {
						BattleField bf = (BattleField)battleField;
						bf.setState(BattleField.STATE_ARRANGEMENT);
						bf.nNewDice = n;
					}
				} else if (msg.cmd.equals("end arrangement")) {
					((BattleField)battleField).setState(BattleField.STATE_NO_SELECTION);
				} else if (msg.cmd.equals("game over")) {
					Integer n = (Integer)msg.arg;
					popUpMessageWindow("Gamer Over", "Player " + n + " wins!!", JOptionPane.INFORMATION_MESSAGE);
					bRun = false;
					agent.close();
					turn = 0;
				} else {
					System.out.println("uknown message: " + msg);
				}
				repaintAll();
			}
		}	
	}
}
