package dice_war;

import java.awt.*;
import java.awt.event.*;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

import javax.swing.*;
import javax.swing.border.BevelBorder;
import javax.swing.border.SoftBevelBorder;
/**
 * GUI server, use GUI to get user's setting(configuration) and pass them to Map and Server
 */
public class ServerGUI extends javax.swing.JPanel implements ActionListener {
	private static final long serialVersionUID = 1L;
	
	private JTabbedPane jTabbedPane1;
	private JPanel history;
	private JPanel setting;
	private JPanel battleField;
	private JPanel widthPanel;
	private JPanel heightPanel;
	private JTextField height;
	private JLabel jLabel2;
	private JTextField width;
	private JLabel jLabel4;
	private JLabel jLabel8;
	private JList arrangeNewDiceWay;
	private JPanel jPanel3;
	private JTextField densityOfEdge;
	private JLabel jLabel7;
	private JPanel densityOfEdgePanel;
	private JButton lookAndFeel;
	private JList lookAndFeelList;
	private JTextField port;
	private JLabel jLabel6;
	private JPanel jPanel2;
	private JTextField serverIP;
	private JLabel jLabel5;
	private JPanel jPanel1;
	private JTextField nCountry;
	private JPanel nCountryPanel;
	private JTextField emptyLevel;
	private JLabel jLabel3;
	private JPanel emptyLevelPanel;
	private JLabel jLabel1;
	private JButton newGame;

	//--------------------------------------------------------------------
	
	// OUCH! dirty code, used by Server when it want to repaint the battleField of ServerGUI
	static ServerGUI ui; 
	public static void main(String[] args) {
		JFrame frame = new JFrame();
		ui = new ServerGUI();
		// TODO: remove this line
		ui.selfCountry = 1;
		
		frame.setTitle("Wow!Dice War!! v0.6 (Server)");
		frame.getContentPane().add(ui);
		frame.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		frame.pack();
		frame.setVisible(true);
		frame.addWindowListener(new WindowAdapter() {
			public void windowClosed(WindowEvent e)
			{
				if (ui.server != null)
					ui.server.stop();
			}
		});
		frame.setResizable(false);
		
		ui.startDW(null);
	}
	
	public ServerGUI() {
		super();
		initGUI();
	}

	static final String[] lookAndFeels = new String[] {
			"javax.swing.plaf.metal.MetalLookAndFeel",
			"com.birosoft.liquid.LiquidLookAndFeel",
			"com.sun.java.swing.plaf.windows.WindowsLookAndFeel", 
		};
	
	private void initGUI() {	
		try {
//			System.out.println(UIManager.getLookAndFeel());
//			UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
			BorderLayout thisLayout = new BorderLayout();
			this.setLayout(thisLayout);
			this.setPreferredSize(new java.awt.Dimension(800, 600));
			{
				jTabbedPane1 = new JTabbedPane();
				this.add(jTabbedPane1, BorderLayout.CENTER);
				jTabbedPane1.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
				{
					battleField = new BattleField();
					jTabbedPane1.addTab("Battle Field", null, battleField, null);
				}
				{
					history = new JPanel();
					jTabbedPane1.addTab("History", null, history, null);
				}
				{
					setting = new JPanel();
					GridBagLayout settingLayout = new GridBagLayout();
					settingLayout.columnWeights = new double[] {0.1,0.1,0.1,0.1,0.1};
					settingLayout.columnWidths = new int[] {7,7,7,7,7};
					settingLayout.rowWeights = new double[] {0.1,0.1,0.1,0.1,0.1};
					settingLayout.rowHeights = new int[] {7,7,7,7,7};
					setting.setLayout(settingLayout);
					jTabbedPane1.addTab("Setting", null, setting, null);
					{
						newGame = new JButton();
						setting.add(newGame, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
						newGame.setText("New Game");
						newGame.addActionListener(this);
					}
					{
						widthPanel = new JPanel();
						BorderLayout widthPanelLayout = new BorderLayout();
						widthPanel.setLayout(widthPanelLayout);
						setting.add(widthPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
						{
							jLabel1 = new JLabel();
							widthPanel.add(jLabel1, BorderLayout.WEST);
							jLabel1.setText("Width");
						}
						{
							width = new JTextField();
							widthPanel.add(width, BorderLayout.CENTER);
							width.setText("12");
						}
					}
					{
						heightPanel = new JPanel();
						setting.add(heightPanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
						BorderLayout jPanel1Layout = new BorderLayout();
						heightPanel.setLayout(jPanel1Layout);
						{
							jLabel2 = new JLabel();
							heightPanel.add(jLabel2, BorderLayout.WEST);
							jLabel2.setText("Height");
						}
						{
							height = new JTextField();
							heightPanel.add(height, BorderLayout.CENTER);
							height.setText("8");
						}
					}
					{
						emptyLevelPanel = new JPanel();
						setting.add(emptyLevelPanel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
						BorderLayout jPanel1Layout1 = new BorderLayout();
						emptyLevelPanel.setLayout(jPanel1Layout1);
						{
							jLabel3 = new JLabel();
							emptyLevelPanel.add(jLabel3, BorderLayout.WEST);
							jLabel3.setText("Empty Level");
						}
						{
							emptyLevel = new JTextField();
							emptyLevelPanel.add(emptyLevel, BorderLayout.CENTER);
							emptyLevel.setText("2");
						}
					}
					{
						nCountryPanel = new JPanel();
						setting.add(nCountryPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
						BorderLayout jPanel1Layout2 = new BorderLayout();
						nCountryPanel.setLayout(jPanel1Layout2);
						{
							jLabel4 = new JLabel();
							nCountryPanel.add(jLabel4, BorderLayout.WEST);
							jLabel4.setText("Number of Country");
						}
						{
							nCountry = new JTextField();
							nCountryPanel.add(nCountry, BorderLayout.CENTER);
							nCountry.setText("2");
							nCountry.setPreferredSize(new java.awt.Dimension(10, 22));
							nCountry.setIgnoreRepaint(true);
						}
					}
					{
						jPanel1 = new JPanel();
						setting.add(jPanel1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
						BorderLayout jPanel1Layout3 = new BorderLayout();
						jPanel1.setLayout(jPanel1Layout3);
					}
					{
						jPanel2 = new JPanel();
						setting.add(jPanel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
						GridBagLayout jPanel2Layout = new GridBagLayout();
						jPanel2Layout.rowWeights = new double[] {0.1, 0.1};
						jPanel2Layout.rowHeights = new int[] {7, 7};
						jPanel2Layout.columnWeights = new double[] {0.1, 0.1};
						jPanel2Layout.columnWidths = new int[] {7, 7};
						jPanel2.setLayout(jPanel2Layout);
						{
							serverIP = new JTextField();
							jPanel2.add(serverIP, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
							serverIP.setText(getIP());
							serverIP.setEditable(false);
						}
						{
							jLabel5 = new JLabel();
							jPanel2.add(jLabel5, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
							jLabel5.setText("Server Name");
						}
						{
							jLabel6 = new JLabel();
							jPanel2.add(jLabel6, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
							jLabel6.setText("Port");
						}
						{
							port = new JTextField();
							jPanel2.add(port, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
							port.setText("2046");
							port.setEditable(false);
						}
					}
					{
						ListModel jList1Model = new DefaultComboBoxModel(
							new String[] { 
									"MetalLookAndFeel",
									"LiquidLookAndFeel",
									"WindowsLookAndFeel", 
							});
						lookAndFeelList = new JList();
						setting.add(lookAndFeelList, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
						lookAndFeelList.setModel(jList1Model);
						lookAndFeelList.setBorder(new SoftBevelBorder(BevelBorder.LOWERED, null, null, null, null));
					}
					{
						lookAndFeel = new JButton();
						setting.add(lookAndFeel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
						lookAndFeel.setText("Change the Look & Feel");
						lookAndFeel.addActionListener(this);
					}
					{
						densityOfEdgePanel = new JPanel();
						setting.add(densityOfEdgePanel, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
						BorderLayout jPanel3Layout = new BorderLayout();
						densityOfEdgePanel.setLayout(jPanel3Layout);
						{
							jLabel7 = new JLabel();
							densityOfEdgePanel.add(jLabel7, BorderLayout.WEST);
							jLabel7.setText("Density of Edge (%)");
						}
						{
							densityOfEdge = new JTextField();
							densityOfEdgePanel.add(densityOfEdge, BorderLayout.CENTER);
							densityOfEdge.setText("70");
						}
					}
					{
						jPanel3 = new JPanel();
						setting.add(jPanel3, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
						BorderLayout jPanel3Layout1 = new BorderLayout();
						jPanel3.setLayout(jPanel3Layout1);
						{
							jLabel8 = new JLabel();
							jPanel3.add(jLabel8, BorderLayout.WEST);
							jLabel8.setText("Arrange New Dices");
						}
						{
							ListModel arrangeNewDiceWayModel = new DefaultComboBoxModel(
								new String[] { "by wall", "by uniform", "by players" });
							arrangeNewDiceWay = new JList();
							jPanel3.add(arrangeNewDiceWay, BorderLayout.CENTER);
							arrangeNewDiceWay.setModel(arrangeNewDiceWayModel);
							arrangeNewDiceWay.setBorder(new SoftBevelBorder(BevelBorder.LOWERED, null, null, null, null));
							arrangeNewDiceWay.setOpaque(false);
							arrangeNewDiceWay.setSelectedIndex(0);
						}
					}
				}
			}
//			jTabbedPane1.setBackgroundAt(0, new Color(0, 0, 255));
//			jTabbedPane1.setBackgroundAt(0, new Color(128, 64, 255));
//			jTabbedPane1.setBackgroundAt(1, new Color(128, 64, 255));
//			jTabbedPane1.setBackgroundAt(2, new Color(128, 64, 255));
			// debug
			jTabbedPane1.setSelectedIndex(2);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/*
	 	return this host's IP
	 	return priority (from high to low): internet IP, LAN IP, 127.0.0.1
	*/
	private String getIP()
	{
		String LAN = "127.0.0.1";
		try {
			Enumeration ni = NetworkInterface.getNetworkInterfaces(); 
			while (ni.hasMoreElements()) { 
				NetworkInterface net = (NetworkInterface)ni.nextElement(); 
				Enumeration ia = net.getInetAddresses(); 
				while (ia.hasMoreElements()) { 
					InetAddress address = (InetAddress)ia.nextElement(); 
					String s = address.getHostAddress();
					if (s.indexOf("192.") == 0 || s.indexOf("10.") == 0 || s.indexOf("127.0.0.1") >= 0) {
							if (s.indexOf("127.0.0.1") < 0)
								LAN = s;
							continue;
					}
					if (s.split("\\.").length == 4)
						return s; 
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		} 
		return LAN;
	}

	int selfCountry;
	int turn;
	int operator;
	Map map;
	public void startDW(Map map)
	{
		this.map = map;
		setupDisplayMapData();
		this.updateUI();
	}
	
	
	boolean[] bUpdatedNodes;
	/**
	 * Similar to UserInterface's, I wanted add some functions here, but ...
	 */
	class BattleField extends JPanel implements ActionListener

	{
		private static final long serialVersionUID = 1L;
		
		static final int BASE_X = -50;
		static final int BASE_Y = -40;
		static final int RADIUS = 15;
		static final int RADIUS_OUT = 30;
		static final int INFO_TOP_Y = 485;		
		static final int END_TURN_X = BASE_X + RADIUS_OUT * 25 + 10;
		static final int END_TURN_Y = BASE_Y + RADIUS_OUT * 2;
		
		Color[] colors = new Color[] {
			Color.WHITE, 
			new Color(255, 80, 64), Color.GREEN, new Color(96, 96, 255), Color.PINK, 
			Color.YELLOW, Color.CYAN, Color.MAGENTA, Color.ORANGE
		};
		
		JButton endTurn;
		Font font;
		Font newNodeFont;
		BattleField()
		{
			font = new Font("Arial", Font.BOLD, 20);
			newNodeFont = new Font("Arial", Font.BOLD, 14);

			this.setLayout(null);
			endTurn = new JButton("End Turn");
			this.add(endTurn);
			endTurn.setFont(new Font("", Font.BOLD, 12));
			endTurn.setSize(endTurn.getPreferredSize());
			endTurn.setLocation(END_TURN_X, END_TURN_Y);
			endTurn.addActionListener(this);
		}
			
		public void paintComponent(Graphics g)
		{
			if (map == null)
				return;
			
			Node[] nodes = map.nodes;
			// draw edges
			g.setColor(Color.BLACK);
			boolean edge[][] = map.edge;
			for (int i=0; i<edge.length; i++) {
				if (nodes[i].country == 0)
					continue;
				for (int j=i+1; j<edge[i].length; j++) {
					if (nodes[j].country == 0)
						continue;
					if (edge[i][j]) {
						int fx = BASE_X + nodes[i].x*RADIUS_OUT*2 + RADIUS;
						int fy = BASE_Y + nodes[i].y*RADIUS_OUT*2 + RADIUS;
						int tx = BASE_X + nodes[j].x*RADIUS_OUT*2 + RADIUS;
						int ty = BASE_Y + nodes[j].y*RADIUS_OUT*2 + RADIUS;
						// revise the length of edge
						int gap;
						if (fx == tx || fy == ty) { // straight line
							gap = RADIUS;
						} else {
							gap = (int)(RADIUS / Math.sqrt(2));
						}
						if (fx < tx) {
							fx += gap;
							tx -= gap;
						} else if (fx > tx) {
							fx -= gap;
							tx += gap;
						}
						if (fy < ty) {
							fy += gap;
							ty -= gap;
						} else if (fy > ty) {
							fy -= gap;
							ty += gap;
						}
						g.drawLine(fx, fy, tx, ty);
					}
				}
			}
			// draw nodes			
			for (int i=0; i<nodes.length; i++) {
				if (nodes[i].country == 0)
					continue;
				drawNode(g, nodes, i, colors[ nodes[i].country ], Color.DARK_GRAY);
			}
			// draw info
			g.setColor(Color.BLUE);
			g.drawLine(0, INFO_TOP_Y, 800, INFO_TOP_Y);
			g.drawLine(0, INFO_TOP_Y+1, 800, INFO_TOP_Y+1);
			g.setColor(Color.WHITE);
			g.drawLine(0, INFO_TOP_Y+2, 800, INFO_TOP_Y+2);
			g.drawLine(0, INFO_TOP_Y+3, 800, INFO_TOP_Y+3);
			g.setColor(new Color(16, 32, 128));
			g.fillRect(0, INFO_TOP_Y+4, 800, 600);

			for (int i=1; i<map.maxConnectedCount.length; i++) {
				int x = i*50;
				int y = INFO_TOP_Y + 20;
				g.setColor(colors[i]);
				g.drawRoundRect(x, y, 30, 30, 5, 5);
				g.drawRoundRect(x+1, y+1, 30-2, 30-2, 3, 3);
				g.setFont(font);
				g.drawString(""+map.maxConnectedCount[i], x+5, y+22);
				if (i == selfCountry) {
					g.drawString("(me)", x-5, y+52);
				}
				if (turn == i) {
					g.setColor(Color.WHITE);
					g.fillRoundRect(x-2, y-10, 30+4, 4, 6, 6);
				}
			}
		}
		
		private int transposeX(int x)
		{
			return BASE_X + x*RADIUS_OUT*2;
		}
		
		private int transposeY(int y)
		{
			return BASE_Y + y*RADIUS_OUT*2;
		}


		private void drawNode(Graphics g, Node[] nodes, int i, Color inside, Color border)
		{
			int x = transposeX(nodes[i].x);
			int y = transposeY(nodes[i].y);
			g.setColor(inside);
			g.fillOval(x, y, RADIUS*2, RADIUS*2);
			g.setColor(border);
			g.drawOval(x, y, RADIUS*2, RADIUS*2);
			g.drawOval(x+1, y, RADIUS*2-2, RADIUS*2);
			g.drawOval(x, y+1, RADIUS*2, RADIUS*2-2);
			g.drawOval(x+1, y+1, RADIUS*2-1, RADIUS*2-1);
			g.setFont(font);
			g.drawString(""+nodes[i].number, x+RADIUS-5, y+RADIUS+7);
			if (bUpdatedNodes[i]) {
				g.setColor(Color.WHITE);
				g.setFont(newNodeFont);
				g.drawString("NEW!", x+RADIUS+8, y+RADIUS-8);
			}
		}

		public void actionPerformed(ActionEvent ae)
		{
			// TODO
		}
	}

	Server server;
	public void actionPerformed(ActionEvent ae)
	{
		if (ae.getSource().equals(newGame)) {
			if (server != null)
				server.stop();
			
			int w = Integer.parseInt(width.getText());
			int h = Integer.parseInt(height.getText());
			int el = Integer.parseInt(emptyLevel.getText());
			int nc = Integer.parseInt(nCountry.getText());
			int de = Integer.parseInt(densityOfEdge.getText());
			int way = arrangeNewDiceWay.getSelectedIndex();
			map = new Map(w, h, nc, el, de);
			map.generateMap();
			setupDisplayMapData();
			
			int p = Integer.parseInt(port.getText());
			server = new Server(p, way, map);
			server.startUp();
			server.serverGUI = this;
			
			JOptionPane.showConfirmDialog(this, "Game start!!", "new game", 
				JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE);
			
			jTabbedPane1.setSelectedIndex(0);
		} else if (ae.getSource().equals(lookAndFeel)) {
			try {
				int index = lookAndFeelList.getSelectedIndex();
				System.out.println(index);
				UIManager.setLookAndFeel(lookAndFeels[index]);
				SwingUtilities.updateComponentTreeUI(this);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	private void setupDisplayMapData()
	{
		if (map == null || map.nodes == null)
			return;
		
		bUpdatedNodes = new boolean[map.nodes.length];
		for (int i=0; i<bUpdatedNodes.length; i++)
			bUpdatedNodes[i] = false;
	}

}
