package dice_war;

import java.io.Serializable;

public class Node implements Serializable, Comparable
{
	private static final long serialVersionUID = 5475169638857622290L;
	int x, y; //display info for UserInterface
	int index; // back track, used when update data
	/** Game-play data, which country it is. Specially, 0 means it's a hole, don't care this. */
	public int country;
	/** Game-play data, how many dices it has */
	public int number; 
	
	public Node(int x, int y, int index, int country, int number)
	{
		this.x = x;
		this.y = y;
		this.index = index;
		this.country = country;
		this.number = number;
	}
	
	public Node(Node n)
	{
		x = n.x;
		y = n.y;
		index = n.index;
		country = n.country;
		number = n.number;
	}

	public String toString()
	{
		return "(" + x + "," + y + ") index: " + index + " country: " + country + " number: " + number;
	}

	// let Node be able to be sorted, from small to large
	public int compareTo(Object obj)
	{
		if (obj instanceof Node == false)
			throw new Shit("Node.compareTo(), wrong type: " + obj);
		Node n = (Node)obj;
		if (number < n.number)
			return -1;
		if (number > n.number)
			return 1;
		return 0;
	}

	void copyValue(Node n)
	{
		x = n.x;
		y = n.y;
		index = n.index;
		country = n.country;
		number = n.number;
	}
}