package dice_war;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.net.SocketException;

/**
 * 
 */
class Message implements Serializable 
{
	private static final long serialVersionUID = -900247592192105324L;
	
	String cmd;
    Object arg;
    
    Message() {}
    Message(String cmd, Object arg)
    {
        this.cmd = cmd;
        this.arg = arg;
    }

    public String toString()
    {
    	return "[msg] " + cmd;
    }

    public String toString2()
    {
    	return "[msg] " + cmd + " " + arg;
    }

}

/**
 * handle all network send/recv 
 */
class Agent
{
	// debug
	int debugLevel = 0;
	
	int country = -1;
    // socket, read-only
    private Socket socket;
//    private PrintWriter pwOut;
//    private BufferedReader bufIn;
    private ObjectOutputStream objOut;
    private ObjectInputStream objIn;
  
    Agent(Socket s)
    {
    	this(s, 0);
     }
    Agent(Socket s, int country) 
    {
        socket = s;
        this.country = country;
        try { 
//        	pwOut = new PrintWriter(getSocket().getOutputStream(), true);        
//        	bufIn = new BufferedReader(new InputStreamReader(getSocket().getInputStream()));
        	objOut = new ObjectOutputStream(getSocket().getOutputStream());
        	objIn = new ObjectInputStream(getSocket().getInputStream());
        } catch (Exception e) {
        	e.printStackTrace();
        }
     }
        
    Socket getSocket() { return socket; }    
//    PrintWriter getPrintWriter() { return pwOut; }
//    BufferedReader getBufferedReader() { return bufIn; }
//    ObjectOutputStream getObjectWriter() { return objOut; }
//    ObjectInputStream getObjectReader() { return objIn; }
    
    Message readMessage()
    {
        Message msg = null;
        try {
        	if (getSocket().isClosed() == false) {
        		msg = (Message)objIn.readObject();
	        	if (debugLevel == 1)
	        		System.out.println("agent: recv: " + msg);
	        	else if (debugLevel == 2)
	        		System.out.println("agent: recv: " + msg.toString2());
        	}
        } catch (EOFException eof) {
            try {
                if (socket.isClosed() == false) {
                    socket.close();
                    System.out.println("EOF, closed");
                }
            } catch (IOException e3) {
                e3.printStackTrace();
            }
        } catch (SocketException se) {
            System.out.println("socket closed");
        } catch (Exception e) {
            e.printStackTrace();             
            try {
                if (socket.isClosed() == false) {
                    socket.close();
                    System.out.println("exception close");
                }
            } catch (IOException e3) {
                e3.printStackTrace();
            }
        }
        return msg;
    }
    // synchonized it to avoid sending broken message when there are to lots to send
    synchronized void sendMessage(Message msg)
    {
    	try {
    		if (getSocket().isClosed() == false) {
    			objOut.writeObject(msg);
            	if (debugLevel == 1)
            		System.out.println("agent: send: " + msg);
            	else if (debugLevel == 2)
            		System.out.println("agent: send: " + msg.toString2());
    		}
		} catch (IOException e) {
			e.printStackTrace();
		}
    }
    
    void close()
    {
        try {
            if (socket.isClosed() == false) {
                socket.close();
                System.out.println("closed normally");
            }
        } catch (IOException e3) {
            e3.printStackTrace();
        }
    }
    
    public String toString()
    {
    	return "[agent] " + country + " " + socket;
    }
}
