package dice_war;

/**
 * The template of AI, 2 necessary methods must be overridden: main() and arrangeNewDices(int nNewDice).
 * You can extend this class and put the class in package dice_war.AI (so it's in the directory dice_war/AI/ ), 
 * then the client(UserInterface) will load it automatically. 
 * Read the example codes in dice_war.AI, you'll know how to write AI faster.
 */
public abstract class AITemplate implements Runnable
{
	private Map map;
	private Agent agent;
	private boolean bMain;
	private int nNewDice;
	
	boolean bRun; 
	/*
	 * data for user, a copy of map.*
	 */
	/** the max number of dices a node(vertex) can have */
	public int MAX_DICE; 
	/** the id of me, "nodes[i].country == myCountry" means node i is yours. */
	public int myCountry;
	/** vertex set of the graph, there are some nodes with "country = 0" which means they are holes, don't care them */
	public Node nodes[];
	/** edge set of the graph, represented by edge list */
	public int edgeList[][];
	/** edge set of the graph, represented by adjacency matrix */
	public boolean edge[][];
	/** probabitlity table, probabilityTable[i][j] means the winning probability about attack(i, j) */
	public double probabilityTable[][]; 
	
	
	public AITemplate()
	{
		MAX_DICE = Map.MAX_DICE;
		initProbaTab();
	}
		
	private void initProbaTab()
	{
		probabilityTable = new double[9][];
		probabilityTable[0] = null;
		probabilityTable[1] = new double[] {
			4.16666667E-1, 9.25925926E-2, 1.15740741E-2, 7.71604938E-4, 2.14334705E-5, 0.00000000, 0.00000000, 0.00000000
		};
		probabilityTable[2] = new double[] {
			8.37962963E-1, 4.43672840E-1, 1.52006173E-1, 3.58796296E-2, 6.10496685E-3, 7.66246571E-4, 7.09487565E-5, 4.72991710E-6
		};
		probabilityTable[3] = new double[] {
			9.72993827E-1, 7.78549383E-1, 4.53575103E-1, 1.91700960E-1, 6.07126867E-2, 1.48785992E-2, 2.88997935E-3, 4.51922080E-4
		};
		probabilityTable[4] = new double[] {
			9.97299383E-1, 9.39236111E-1, 7.42830504E-1, 4.59528249E-1, 2.20442351E-1, 8.34228379E-2, 2.54497490E-2, 6.37947569E-3
		};
		probabilityTable[5] = new double[] {
			9.99849966E-1, 9.87940101E-1, 9.09347136E-1, 7.18078418E-1, 4.63653597E-1, 2.42449101E-1, 1.03625986E-1, 3.67418668E-2
		};
		probabilityTable[6] = new double[] {
			9.99996428E-1, 9.98216854E-1, 9.75299811E-1, 8.83953468E-1, 6.99616388E-1, 4.66730602E-1, 2.59983822E-1, 1.21506966E-1
		};
		probabilityTable[7] = new double[] {
			1.00000000, 9.99801343E-1, 9.94663364E-1, 9.61535884E-1, 8.62376516E-1, 6.85164991E-1, 4.69139168E-1, 2.74375531E-1
		};
		probabilityTable[8] = new double[] {
			1.00000000, 9.99983445E-1, 9.99069174E-1, 9.89534037E-1, 9.47731463E-1, 8.43873820E-1, 6.73455638E-1, 4.71090727E-1
		};
	}
	/*
	 * methods for user
	 */
	/** attack the node 'to' by the node 'from' */
	final public void attack(int from, int to)
	{
		if (isAttackable(from, to) == false)
			return;
		
		Message msg = new Message("attack", new int[] { from, to });
		agent.sendMessage(msg);
		sleep(500);
	}
	/** append a dice to the node n */
	final public void appendNewDice(Node n)
	{
		if (nodes[n.index].number >= Map.MAX_DICE)
			return;
			
		Message msg = new Message("append dice", new Integer(n.index));
		agent.sendMessage(msg);
		sleep(500);
	}
	/** see if the node 'from' can attack the node 'to' */
	public boolean isAttackable(int from, int to)
	{
		return edge[from][to] && nodes[from].country != 0 && nodes[to].country != 0 
				&& nodes[from].country != nodes[to].country && nodes[from].number > 1 && nodes[from].country == myCountry;
	}

	/**
	 * the core of game play, when it's your turn, UserInterface will call this method.
	 * Override this to do the strategy of attack.
	 */ 
	abstract protected void main();
	/**
	 * the core of game play, when it's your turn, UserInterface will call this method.
	 * Override this to do the strategy of attack.
	 */ 
	abstract protected void arrangeNewDices(int nNewDice);
	
	//-------------------------------------------------------------
	
	/*
	 *	called by UserInterface when it's the turn to attack 
	 */
	synchronized final void process(Map map, Agent agent, int myCountry)
	{
		while (bRun) {
			sleep(100);
		}
		this.map = map;
		this.agent = agent;
		this.myCountry = myCountry;
		bMain = true;
		Thread th = new Thread(this);
		th.start();
	}
	/*
	 * called by UserInterface when it's the turn to arrange new dices.
	 * 
	 * NewDice: the number of new dices to arrange
	 */
	final void processArrangeNewDice(Map map, Agent agent, int myCountry, int nNewDice)
	{
		while (bRun) {
			sleep(100);
		}
		System.out.println("[AITemplate] start arrange new dices: " + nNewDice);
		this.map = map;
		this.agent = agent;
		this.myCountry = myCountry;
		this.nNewDice = nNewDice;
		bMain = false;
		Thread th = new Thread(this);
		th.start();
	}
	final public void run()
	{
		bRun = true;
		preProcessData();
		if (bMain)
			main();
		else
			arrangeNewDices(nNewDice);			
		postProcessData();
		bRun = false;
	}
	
	private void preProcessData()
	{
		nodes = new Node[map.nodes.length];
		for (int i=0; i<nodes.length; i++)
			nodes[i] = new Node(map.nodes[i]);
		
		edge = new boolean[nodes.length][nodes.length];
		for (int i=0; i<edge.length; i++)
			for (int j=0; j<edge[i].length; j++)
				edge[i][j] = map.edge[i][j];
		
		edgeList = new int[nodes.length][];
		for (int i=0; i<edgeList.length; i++) {
			edgeList[i] = new int[map.edgeList[i].length];
			for (int j=0; j<edgeList[i].length; j++)
				edgeList[i][j] = map.edgeList[i][j];
		}
	}
	
	private void postProcessData()
	{
		if (bMain) {
			Message m = new Message("end turn", null);
			agent.sendMessage(m);
			System.out.println("[AITemplate] send 'end turn'");
		} else {
			Message m = new Message("end my arrangement", null);
			agent.sendMessage(m);
			System.out.println("[AITemplate] send 'end my arrangement'");			
		}
	}
	
	private void sleep(int usec)
	{
		try {
			Thread.sleep(usec);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

	void reset()
	{
		myCountry = 0;
		map = null;
		agent = null;
		
		nodes = null;
		edgeList =null;
		edge = null;

		bRun = false;
		bMain = false;
		
		nNewDice = 0;
	}

}
