package dice_war.AI;

import java.util.*;

import dice_war.*;

/**
 * An example of AI, the strategy is simple, attack if the enemy's dices are equal or less than mine.
 * arrange new dices to the nodes which have had more dices, so this makes them be strong ones
 */
public class Greedy2 extends AIToolkit
{
	Random random;
	public Greedy2()
	{
		random = new Random(Calendar.getInstance().getTimeInMillis());
	}
	
	protected void main()
	{
		boolean bAttacked;
		do {
			bAttacked = false;
			for (int i=0; i<nodes.length; i++) {
				if (nodes[i].country != myCountry)
					continue;
				
				for (int j=0; j<edgeList[i].length; j++) {
					int to = edgeList[i][j];
					if (isAttackable(i, to) && nodes[i].number >= nodes[to].number) {
						attack(i, to);
						bAttacked = true;
					}
				}
			}
		} while (bAttacked);
	}

	protected void arrangeNewDices(int nNewDice)
	{
		// build up index structure
		Node[] ns = extractMyNodes();
		Arrays.sort(ns);
		// make arrangement
		for (int i=ns.length-1; i>=0 && nNewDice>0; ) {
			Node n = (Node)ns[i];
			if (n.number < MAX_DICE) {
				System.out.println("g2: append: " + n);
				appendNewDice(n);
				nNewDice--;
			} else {
				i--;
			}
		}
	}
}
