package dice_war.AI;

import java.util.*;

import dice_war.*;

/**
 * An example of AI, the strategy is simple, attack if it's attackable.
 * arrange more new dices to the nodes which have more enemies in neighbor
 */
public class GoAhead extends AITemplate
{
	Random random;
	public GoAhead()
	{
		random = new Random(Calendar.getInstance().getTimeInMillis());
	}
	
	protected void main()
	{
		boolean bAttacked;
		do {
			bAttacked = false;
			for (int i=0; i<nodes.length; i++) {
				if (nodes[i].country != myCountry)
					continue;
				
				for (int j=0; j<edgeList[i].length; j++) {
					int to = edgeList[i][j];
					if (isAttackable(i, to)) {
						attack(i, to);
						bAttacked = true;
					}
				}
			}
		} while (bAttacked);
	}

	protected void arrangeNewDices(int nNewDice)
	{
		// build up index structure
		ArrayList wall = new ArrayList();
		ArrayList lists = new ArrayList();
		for (int i=0; i<nodes.length; i++)
			if (nodes[i].country == myCountry) {
				int j;
				for (j=0; j<edgeList[i].length; j++) {
					int neighbor = edgeList[i][j];
					if (nodes[neighbor].country != 0 && nodes[neighbor].country != myCountry) {
						// the more enemy, the more change to get new dices
						wall.add(nodes[i]);
					}
				}
				lists.add(nodes[i]);
			}
		// make arrangement
		// wall nodes take half of new nodes first
		int i;
		int nArrangement = nNewDice;
		for (i=0; i<nArrangement && wall.size()>0; ) {
			int k = random.nextInt(wall.size());
			Node n = (Node)wall.get(k);
			if (n.number < MAX_DICE) {
				appendNewDice(n);
				i++;
			} else {
				wall.remove(k);
			}
		}
		// all nodes take the other half
		for (; i<nArrangement && lists.size()>0; ) {
			int k = random.nextInt(lists.size());
			Node n = (Node)lists.get(k);
			if (n.number < MAX_DICE) {
				appendNewDice(n);
				i++;
			} else {
				lists.remove(k);
			}
		}
	}
}
