package dice_war.AI;

import java.util.*;

import dice_war.AITemplate;
import dice_war.Node;

/**
 * A subclass of AITemplate with some useful methods, you can extend this class and 
 * get easier to realize your strategy
 */
abstract public class AIToolkit extends AITemplate
{
	/**
	 * extract all my nodes and store them in an array
	 * @return the Node array which stores my nodes
	 */
	Node[] extractMyNodes()
	{
		ArrayList lists = new ArrayList();
		for (int i=0; i<nodes.length; i++)
			if (nodes[i].country == myCountry) {
				lists.add(nodes[i]);
			}
		Object[] t = lists.toArray();
		Node[] ns = new Node[t.length];
		for (int i=0; i<ns.length; i++)
			ns[i] = (Node)t[i];
		return ns;
	}
	/**
	 * find the neighbor with maximum dices
	 * @param n the index of nodes
	 * @return the index of the neighbor with maximum dices, return -1 if there is no neighbor
	 */
	int findMaxNeighbor(int n)
	{
		int max = -1;
		for (int i=0; i<edgeList[n].length; i++) {
			int neighbor = edgeList[n][i];
			if (nodes[neighbor].country == nodes[n].country) {
				if (max == -1 || nodes[neighbor].number > nodes[max].number)
					max = neighbor;
			}
		}
		return max;
	}
}
