package SpecialBullCow;
import java.awt.BorderLayout;
import java.awt.CardLayout;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;

import javax.swing.JTextArea;
import javax.swing.WindowConstants;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/**
* This code was generated using CloudGarden's Jigloo
* SWT/Swing GUI Builder, which is free for non-commercial
* use. If Jigloo is being used commercially (ie, by a corporation,
* company or business for any purpose whatever) then you
* should purchase a license for each developer using Jigloo.
* Please visit www.cloudgarden.com for details.
* Use of Jigloo implies acceptance of these licensing terms.
* *************************************
* A COMMERCIAL LICENSE HAS NOT BEEN PURCHASED
* for this machine, so Jigloo or this code cannot be used legally
* for any corporate or commercial purpose.
* *************************************
*/

/*
 * by fcamel, 2005/12/09
 * 
 * the GUI for Agent.java
 */
public class MainPanel extends javax.swing.JPanel implements ActionListener {
	private JPanel jPanel1;
	private JScrollPane jsBest10;
	private JButton bRightMore;
	private JButton bLeftMore;
	private JButton bDraw;
	private JButton bRight;
	private JButton bStart;
	private JButton bFinish;
	private JPanel jPanel5;
	private JButton bLeft;
	private JLabel lDescription;
	private JLabel lRight;
	private JLabel lLeft;
	private JScrollPane jsHistory;
	private JPanel jPanel4;
	private JPanel jPanel3;
	private JPanel jPanel2;

	/**
	* Auto-generated main method to display this 
	* JPanel inside a new JFrame.
	*/
	public static void main(String[] args) {
		JFrame frame = new JFrame();
		frame.getContentPane().add(new MainPanel());
		frame.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		frame.pack();
		frame.setVisible(true);
	}
	
	Agent agent;
	JTextArea history, best10;
	public MainPanel() {
		super();
		agent = new Agent();
		history = new JTextArea(30, 30);
		history.setEditable(false);
		best10 = new JTextArea(11, 20);
		best10.setEditable(false);
		
		initGUI();
	}
	
	private void initGUI() {
		try {
			GridLayout thisLayout = new GridLayout(1, 1);
			this.setLayout(thisLayout);
			this.setPreferredSize(new java.awt.Dimension(600, 300));
			this.setSize(600, 600);
			{
				jPanel1 = new JPanel();
				GridBagLayout jPanel1Layout = new GridBagLayout();
				jPanel1Layout.columnWeights = new double[] {0.1};
				jPanel1Layout.columnWidths = new int[] {7};
				jPanel1Layout.rowWeights = new double[] {0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1};
				jPanel1Layout.rowHeights = new int[] {7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7};
				jPanel1.setLayout(jPanel1Layout);
				this.add(jPanel1);
				jPanel1.setSize(500, 300);
				{
					jPanel5 = new JPanel();
					GridLayout jPanel5Layout = new GridLayout(1, 2);
					jPanel5Layout.setColumns(2);
					jPanel5.setLayout(jPanel5Layout);
					jPanel1.add(jPanel5, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
					jPanel5.setSize(300, 66);
					{
						bStart = new JButton();
						jPanel5.add(bStart);
						bStart.setText("Start");
						bStart.addActionListener(this);
					}
					{
						bFinish = new JButton();
						jPanel5.add(bFinish);
						bFinish.setText("Finish");
						bFinish.addActionListener(this);
					}
				}
				{
					jPanel3 = new JPanel();
					GridBagLayout jPanel3Layout = new GridBagLayout();
					jPanel3Layout.columnWeights = new double[] {0.1,0.1};
					jPanel3Layout.columnWidths = new int[] {7,7};
					jPanel3Layout.rowWeights = new double[] {0.1,0.1};
					jPanel3Layout.rowHeights = new int[] {7,7};
					jPanel3.setLayout(jPanel3Layout);
					jPanel1.add(jPanel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
					jPanel3.setSize(300, 66);
					jPanel3.setBackground(new java.awt.Color(255,255,255));
					{
						lLeft = new JLabel();
						jPanel3.add(lLeft, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.VERTICAL, new Insets(0, 0, 0, 0), 0, 0));
						lLeft.setText("????");
					}
					{
						lRight = new JLabel();
						jPanel3.add(lRight, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.VERTICAL, new Insets(0, 0, 0, 0), 0, 0));
						lRight.setText("????");
					}
					{
						lDescription = new JLabel();
						jPanel3.add(lDescription, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.VERTICAL, new Insets(0, 0, 0, 0), 0, 0));
						lDescription.setText("Which one is more feasible?");
					}
				}
				{
					jPanel4 = new JPanel();
					GridBagLayout jPanel4Layout = new GridBagLayout();
					jPanel4Layout.columnWeights = new double[] {0.1,0.1,0.1,0.1};
					jPanel4Layout.columnWidths = new int[] {7,7,7,7};
					jPanel4Layout.rowWeights = new double[] {0.1,0.1};
					jPanel4Layout.rowHeights = new int[] {7,7};
					jPanel4.setLayout(jPanel4Layout);
					jPanel1.add(jPanel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
					jPanel4.setSize(300, 66);
					{
						bLeft = new JButton();
						jPanel4.add(bLeft, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
						bLeft.setText("Left");
						bLeft.addActionListener(this);
					}
					{
						bRight = new JButton();
						jPanel4.add(bRight, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
						bRight.setText("Right");
						bRight.addActionListener(this);
					}
					{
						bDraw = new JButton();
						jPanel4.add(bDraw, new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
						bDraw.setText("Draw");
						bDraw.addActionListener(this);
					}
					{
						bLeftMore = new JButton();
						jPanel4.add(bLeftMore, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
						bLeftMore.setText("Left More!!");
						bLeftMore.addActionListener(this);
					}
					{
						bRightMore = new JButton();
						jPanel4.add(bRightMore, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
						bRightMore.setText("Right More!!");
						bRightMore.addActionListener(this);
					}
				}
				{
					jsBest10 = new JScrollPane();
					jPanel1.add(jsBest10, new GridBagConstraints(0, 3, 1, 17, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
					jsBest10.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
					jsBest10.setSize(300, 200);
					jsBest10.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
					jsBest10.setViewportView(best10);
				}
			}
			{
				jPanel2 = new JPanel();
				BorderLayout jPanel2Layout = new BorderLayout();
				jPanel2.setLayout(jPanel2Layout);
				this.add(jPanel2);
				jPanel2.setSize(300, 600);
				{
					jsHistory = new JScrollPane();
					jPanel2.add(jsHistory, BorderLayout.CENTER);
					jsHistory.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
					jsHistory.setSize(400, 300);
					jsHistory.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
					jsHistory.setViewportView(history);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	boolean bRun = false;
	public void actionPerformed(ActionEvent ae)
	{
		JButton src = (JButton)ae.getSource();
		// bStart/bFinish
		if (src.equals(bStart)) {
			bRun = true;
			Agent.Number[] t = agent.initialization();
			lLeft.setText(t[0].toString());
			lRight.setText(t[1].toString());
			history.append("<-------------------------------->\n");
			best10.append("<----------------->\n");
		} else if (src.equals(bFinish)) {
			bRun = false;
			agent.finish = true;
		}
		if (bRun == false)
			return;
		boolean newRound = false;
		int which = Agent.RESULT_DRAW;
		String s = "[R" + agent.round + "] " + lLeft.getText() + " " + lRight.getText() + " -> ";
		if (src.equals(bLeft)) {
			newRound = true;
			System.out.println("left");
			which = Agent.RESULT_LEFT;
			s += "left";
		} else if (src.equals(bRight)) {
			newRound = true;
			System.out.println("right");
			which = Agent.RESULT_RIGHT;
			s += "right";
		} else if (src.equals(bLeftMore)) {
			newRound = true;
			System.out.println("left more");
			which = Agent.RESULT_LEFT | Agent.RESULT_MORE;
			s += "left more!!";
		} else if (src.equals(bRightMore)) {
			newRound = true;
			System.out.println("right more");
			which = Agent.RESULT_RIGHT | Agent.RESULT_MORE;
			s += "right more!!";
		} else if (src.equals(bDraw)) {
			newRound = true;
			System.out.println("draw");
			which = Agent.RESULT_DRAW;
			s += "draw";
		}
		
		if (newRound) {
			// update content
			Agent.Number[] t = agent.guessNextNumbers(which);
			lLeft.setText(t[0].toString());
			lRight.setText(t[1].toString());
			// update display
			history.append(s + "\n");
			best10.append("[Round " + agent.round +"]\n");
			for (int i=0; i<10; i++)
				best10.append(agent.all[i].toComplexString() + "\n");
		}
	}

}
