/*
 * by fcamel, 2005/12/09
 * 
 * Special Bull & Cow (Guess Number)
 * 
 * human set a number in agent.answer, 
 * let computer to guess 2 number each round,  
 * and then human response which one is better (not ?A?B) or draw.
 * if there is a exact number (i.e. 4A0B), human should tell the computer.
 *  
 */
package SpecialBullCow;

import java.text.DecimalFormat;
import java.util.*;
import java.awt.event.*;

import javax.swing.*;

public class Agent
{
	static class Number implements Comparable
	{
		int number[];
		double fitness;
		
		Number(int num[])
		{
			number = new int[4];
			for (int i=0; i<number.length; i++)
				number[i] = num[i];
			fitness = 0.0;
		}
		
		int[] nanb(Number n)
		{
			int ab[] = new int[] { 0, 0 };
			for (int i=0; i<number.length; i++)
				for (int j=0; j<number.length; j++) {
					if (number[i] == n.number[j]) {
						if (i == j)
							ab[0]++;
						else
							ab[1]++;
					}
				}
			return ab;
		}
		
		int evaluateScore(Number n)
		{
			int[] ab = nanb(n);
			return ab[0]*2 + ab[1];
		}

		public int compareTo(Object a)
		{
			Number n = (Number)a;
			if (fitness > n.fitness)
				return -1;
			else if (fitness < n.fitness)
				return 1;
			return 0;
		}
	
		public String toComplexString()
		{
			StringBuffer sb = new StringBuffer(number.length);
			for (int i=0; i<number.length; i++)
				sb.append(number[i]);
			DecimalFormat df = new DecimalFormat("#.##");
			sb.append(" (" + df.format(fitness) + ")");
			return sb.toString();
		}
		
		public String toString()
		{
			StringBuffer sb = new StringBuffer(number.length);
			for (int i=0; i<number.length; i++)
				sb.append(number[i]);
			return sb.toString();
		}
		
		public boolean equals(Object a)
		{
			if (a instanceof Number == false)
				return false;
			Number n = (Number)a;
			int[] ab = nanb(n);
			return ab[0] == 4 && ab[1] == 0;
		}
	}
	
	Random random;
	public Agent()
	{
		random = new Random(Calendar.getInstance().getTimeInMillis());
	}
	/*
	 * return x if n is more similar to x than y,
	 * return y if n is more similar to y than x,
	 * return null otherwise
	 */ 
	Number getSimilarOne(Number n, Number x, Number y)
	{
		int fx = n.evaluateScore(x);
		int fy = n.evaluateScore(y);
		if (fx > fy)
			return x;
		else if (fx < fy)
			return y;
		return null;
	}
	
	Number[] all;
	Number[] initialization()
	{
		// init value
		finish = false;
		round = 0;
		
		int num[] = new int[4];
		all = new Number[10*9*8*7];
		int k = 0;
		for (int i=0; i<10; i++)
			for (int j=0; j<10; j++) {
				if (j == i)
					continue;
				for (int x=0; x<10; x++) {
					if (x == i || x == j)
						continue;
					for (int y=0; y<10; y++) {
						if (y == i || y == j || y == x)
							continue;
						num[0] = i;
						num[1] = j;
						num[2] = x;
						num[3] = y;
						all[k++] = new Number(num);
					}
				}
			}
		// disturb the init order (avoid 1st selection being not random enough)
		for (int i=0; i<all.length; i++) {
			int a = random.nextInt(all.length);
			int b = random.nextInt(all.length);
			Number t = all[a];
			all[a] = all[b];
			all[b] = t;
		}
		// init 1st guess numbers
		setNewCandidate();
		return new Number[] { left, right };
	}
	
	Number answer; // for auto-test
	
	final int NORMAL=0, WRONG = 1, RANDOM=2;
	int mode = WRONG;
	// TODO ask human, GUI
	Number ask(Number left, Number right)
	{
		if (round % 5 == 0) {
			if (mode == NORMAL) {
				Number result = getSimilarOne(answer, left, right);
				if (result == null)
					return left;
				return result==left ? right : left;
			} else if (mode == RANDOM)
				return random.nextInt(2)==0 ? left : right;
			else
				return getSimilarOne(answer, left, right);
		} else {
			return getSimilarOne(answer, left, right);
		}
	}
	
	/*
	// a bad idea, user's feedback is not as designer's expection
	Number ask(Number left, Number right)
	{
		for (int i=0; i<answer.number.length; i++) {
			if (left.number[i] != right.number[i]) {
				if (answer.number[i] == left.number[i])
					return left;
				else
					return right;
			}
		}
		return null;
	}*/
	
	Number left, right;
	int range = 1000;
	void setNewCandidate()
	{
		round++;
		if (round % 10 == 0 && range > 10)
			range /= 10;
		
		int t1 = random.nextInt(range);
		int t2 = 0;
		do {
			t2 = random.nextInt(range);
		} while (t1 == t2);
		left = all[t1];
		right = all[t2];	
	}
	
	static final int RESULT_DRAW = 0;
	static final int RESULT_LEFT = 1;
	static final int RESULT_RIGHT = 2;
	static final int RESULT_MORE = 4;
	Number[] guessNextNumbers(int result)
	{
		if (result == RESULT_DRAW) { // left = right, rebalance all similar numbers
			double f = (left.fitness + right.fitness) / 2.0;
			left.fitness = right.fitness = f;
			for (int i=0; i<all.length; i++) {
				if (getSimilarOne(all[i], left, right) == null)
					all[i].fitness = (all[i].fitness+f) / 2.0;;
			}
		} else { // adjust fitness by feedback
			Number r = (result&RESULT_LEFT)==RESULT_LEFT ? left : right;
			for (int i=0; i<all.length; i++) {
				all[i].fitness += all[i].evaluateScore(r);
				if ((result&RESULT_MORE) == RESULT_MORE) // double the effect
					all[i].fitness += all[i].evaluateScore(r);
			}
			r.fitness = 0.0;
		}
		Arrays.sort(all);
		setNewCandidate();
		return new Number[] { left, right };
	}
	
	int round;
	boolean finish;
	boolean isFinished()
	{
		return finish || round >= 1000;
	}
}
