/*
 *
 * ghanoi.c           Graphic Hanoi Tower
 *
 * running only on DOS
 *
 * written by F.Camel 2002/12/08
 *
*/
#include <graphics.h>
#include <dos.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>

enum { MAX=15 };

typedef struct {
	int x, y;
	int X, Y;
} Rect;

/*
 *  compute global value
 */
int num = 3;
int tower[3][MAX+5];
int height[3];
/*
 *  graphic global value
 */
Rect r[MAX+5];		// disks
int gheight[3];
int gx, gap;		// gap x, gap
int h, w;
int lag = 40;		// control speed
/*
 *
 *	Draw Functions
 *
*/
void init_draw(void)
{
	int gdriver = DETECT, gmode, errorcode;

	initgraph(&gdriver, &gmode, "../bgi");
	errorcode = graphresult();

	if (errorcode != grOk)  /* an error occurred */ {
		printf("Graphics error: %s\n", grapherrormsg(errorcode));
		printf("Press any key to halt:");
		getch();
		exit(1);             /* return with error code */
	}
}
// interactive interface, get User's command
void GetKey(void)
{
	int c;

	if (kbhit()) {
		if ((c=getch()) == '\033')
			closegraph();
		else if (c == '+')
			lag -= 5;
		else if (c == '-')
			lag += 5;
		else if (c == ' ')
			getch();

		if (lag < 1)
			lag = 1;
		else if (lag > 10000)
			lag = 10000;
	}
}

void title(void)
{
	settextstyle(GOTHIC_FONT, 0, 6);
	setcolor(WHITE);
	outtextxy(23, 20, "F.Camel's Tower of Hanoi");
}
// show text
void msg(int x, int y, int color, char *s)
{
	settextstyle(SMALL_FONT, 0, 7);
	setcolor(color);
	outtextxy(x, y, s);
}
// draw a rect
void rect(int x, int y, int X, int Y)
{
	setcolor(CYAN);
	setlinestyle(SOLID_LINE, 0, NORM_WIDTH);
	setfillstyle(SOLID_FILL, CYAN);
	bar3d(x, y, X, Y, 20, 1);
}
// clear the rect(x, y, X, Y)
void gclear(int x, int y, int X, int Y)
{
	static int poly[10];

	poly[0] = x;	poly[1] = y;
	poly[2] = x;	poly[3] = Y;
	poly[4] = X;	poly[5] = Y;
	poly[6] = X;	poly[7] = y;
	poly[8] = x;	poly[9] = y;

	setlinestyle(USERBIT_LINE, 0, NORM_WIDTH);
	setfillstyle(SOLID_FILL, BLACK);
	fillpoly(5, poly);
}
// move r once per "way", do "times"
void gmove_down(Rect r, int way, int times)
{
	int x, y, X, Y;
	int i, dist;

	x = r.x;
	y = r.y;
	X = r.X;
	Y = r.Y;
	for (i=times; i>=0; i--) {
		GetKey();

		dist = -i * way;
		rect(x, y+dist, X, Y+dist);
		delay(lag);
	}
	for (i=times; i>0; i--) {
		GetKey();

		dist = -i * way;
		gclear(x, y+dist-15, X+20, Y+dist+2);
		delay(lag);
	}
}
// move r1 once per "way", do "times", r2 is right below r1
// if r1 equals r2, DO NOT use r2
void gmove_up(Rect r1, Rect r2, int way, int times)//, int isClearLast)
{
	int x, y, X, Y;
	int i, dist;

	x = r1.x;
	y = r1.y;
	X = r1.X;
	Y = r1.Y;
	for (i=0; i<=times; i++) {
		GetKey();

		dist = -i * way;
		rect(x, y+dist, X, Y+dist);
		delay(lag);
	}
	for (i=0; i<=times; i++) {
		GetKey();

		dist = -i * way;
		gclear(x, y+dist-15, X+20, Y+dist+2);
		if (i < times)
			rect(x, y+dist-way, X, Y+dist-way);
		if (x!=r2.x || y!=r2.y || X!=r2.X || Y!=r2.Y) {
			if (i == 0 && i < num-1)
				rect(r2.x, r2.y, r2.X, r2.Y);
		}
		delay(lag);
	}
}
// let disk "go"!!
void go(int from, int to)
{
	static const int dist = 40;		// move dist (per turn)
	static const int gap = 200;
	int i;
	int t1, t2;
	int times;

	t1 = tower[from][ height[from]-1 ];
	times = r[t1].y / dist - 3;

	if (height[from]-2 >= 0) {
		t2 = tower[from][ height[from]-2 ];
		gmove_up(r[t1], r[t2], dist, times);
	} else {
		gmove_up(r[t1], r[t1], dist, times);
	}

	r[t1].x += gap * (to-from);
	r[t1].X += gap * (to-from);
	r[t1].Y = gheight[to];
	r[t1].y = r[t1].Y - 10;
	gheight[from] += h;
	gheight[to] -= h;

	times = r[t1].y / dist - 3;
	gmove_down(r[t1], dist, times);
}

void init_rect(void)
{
	int bx, by, bX, bY;	// base points
	int i;

	gx = 5;
	w = gx / 2 + 1;
	h = 20;
	bx = 92;
	by = 200 + (MAX-1 - num)*h;
	bX = 105;
	bY = 210 + (MAX-1 - num)*h;

	for (i=0; i<num; i++) {
		r[i].x = bx - i*w;
		r[i].y = by + h*i;
		r[i].X = bX + i*gx;
		r[i].Y = bY + h*i;
	}

	gheight[0] = gheight[1] = gheight[2] = r[num-1].Y;
	gheight[0] = r[0].Y - h;
}
/*
 *
 *	Compute Functions
 *
*/
void dump(void)
{
	int i, j;

	printf("=====================================\n");
	for (i=0; i<3; i++) {
		for (j=0; j<height[i]; j++)
			printf("%2d ", tower[i][j]);
		putchar('\n');
	}
}

void init_tower(int num)
{
	int i;

	for (i=0; i<num; i++)
		tower[0][i] = num-1 - i;
	height[0] = num;
	height[1] = height[2] = 0;
}

void move(int from, int to)
{
	go(from, to);
	tower[to][ height[to] ] = tower[from][ height[from]-1 ];
	height[to]++;
	height[from]--;
    //	dump();
}

void hanoi(int from, int to, int tmp, int num)
{
	if (num > 1) {
		hanoi(from, tmp, to, num-1);
		move(from, to);
		hanoi(tmp, to, from, num-1);
	} else {
		move(from, to);
	}
}
int main(void)
{
	int i;

	printf("Please Input a number(1 - 15):\t");
	scanf("%d", &num);
	if (num < 1 || num > 15) {
		fprintf(stderr, "wrong input %d\n", num);
		exit(1);
	}
	init_tower(num);

	init_rect();

	init_draw();

	gclear(0, 0, 640, 480);
	title();
	for (i=0; i<num; i++)
		rect(r[i].x, r[i].y, r[i].X, r[i].Y);
	msg(45, 90, GREEN,  "press +- to accelerate/decelerate");
	msg(45, 110, GREEN, "      ESC to exit");
	msg(45, 130, GREEN, "      SPACE to pause");
	msg(130, 235, YELLOW, "  Pleas press any key to start   ");

	if (getch() == '\033')
		closegraph();

	gclear(0, 0, 640, 480);
	title();
	for (i=0; i<num; i++)
		rect(r[i].x, r[i].y, r[i].X, r[i].Y);

	hanoi(0, 2, 1, num);

	msg(270, 200, YELLOW, "Finish");
	msg(130, 235, YELLOW, "  Pleas press any key to exit   ");

	getch();

	closegraph();
	return 0;
}