/*
 * by fcamel, 2005/12/13
 * 
 * the GUI for BullAndCow
 */
package BullCow;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;

import javax.swing.WindowConstants;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

/**
* This code was generated using CloudGarden's Jigloo
* SWT/Swing GUI Builder, which is free for non-commercial
* use. If Jigloo is being used commercially (ie, by a corporation,
* company or business for any purpose whatever) then you
* should purchase a license for each developer using Jigloo.
* Please visit www.cloudgarden.com for details.
* Use of Jigloo implies acceptance of these licensing terms.
* *************************************
* A COMMERCIAL LICENSE HAS NOT BEEN PURCHASED
* for this machine, so Jigloo or this code cannot be used legally
* for any corporate or commercial purpose.
* *************************************
*/
public class BullAndCowUI extends javax.swing.JPanel implements ActionListener {
	private JPanel jPanel1;
	private JLabel jLabel4;
	private JButton start;
	private JButton submit;
	private JTextArea remaining;
	private JTextArea history;
	private JLabel jLabel3;
	private JTextField nb;
	private JTextField na;
	private JLabel guessNumber;
	private JLabel jLabel2;
	private JLabel jLabel1;
	private JScrollPane jScrollPane2;
	private JScrollPane jScrollPane1;

	/**
	* Auto-generated main method to display this 
	* JPanel inside a new JFrame.
	*/
	public static void main(String[] args) {
		JFrame frame = new JFrame();
		frame.getContentPane().add(new BullAndCowUI());
		frame.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		frame.pack();
		frame.setVisible(true);
	}
	
	BullAndCow bac;
	String arrayToString(int a[])
	{
		StringBuffer sb = new StringBuffer(a.length);
		for (int i=0; i<a.length; i++)
			sb.append(a[i]);
		return sb.toString();
	}
	
	void initLogicData()
	{
		bac = new BullAndCow();
		guessNumber.setText(arrayToString(bac.guess));	
	}
	
	public BullAndCowUI() {
		super();
		initGUI();
		initLogicData();
	}
	
	private void initGUI() {
		try {
			GridBagLayout thisLayout = new GridBagLayout();
			thisLayout.columnWeights = new double[] {0.1,0.1,0.1,0.1,0.1};
			thisLayout.columnWidths = new int[] {7,7,7,7,7};
			thisLayout.rowWeights = new double[] {0.1,0.1,0.1,0.1,0.1};
			thisLayout.rowHeights = new int[] {7,7,7,7,7};
			this.setLayout(thisLayout);
			this.setPreferredSize(new java.awt.Dimension(490, 312));
			{
				jPanel1 = new JPanel();
				GridBagLayout jPanel1Layout = new GridBagLayout();
				jPanel1Layout.columnWeights = new double[] {0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1};
				jPanel1Layout.columnWidths = new int[] {7,7,7,7,7,7,7,7,7};
				jPanel1Layout.rowWeights = new double[] {0.1,0.1};
				jPanel1Layout.rowHeights = new int[] {7,7};
				jPanel1.setLayout(jPanel1Layout);
				this.add(jPanel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
				jPanel1.setBackground(new java.awt.Color(162,208,255));
				{
					jLabel1 = new JLabel();
					jPanel1.add(jLabel1, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.VERTICAL, new Insets(0, 0, 0, 0), 0, 0));
					jLabel1.setText("I guess");
					jLabel1.setFont(new java.awt.Font("Dialog",1,18));
				}
				{
					jLabel2 = new JLabel();
					jPanel1.add(jLabel2, new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.VERTICAL, new Insets(0, 0, 0, 0), 0, 0));
					jLabel2.setText("Your response");
					jLabel2.setFont(new java.awt.Font("Dialog",1,18));
				}
				{
					guessNumber = new JLabel();
					jPanel1.add(guessNumber, new GridBagConstraints(4, 0, 4, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.VERTICAL, new Insets(0, 0, 0, 0), 0, 0));
					guessNumber.setText("????");
					guessNumber.setBackground(new java.awt.Color(0,128,255));
					guessNumber.setForeground(new java.awt.Color(226,119,1));
					guessNumber.setFont(new java.awt.Font("Dialog",1,16));
				}
				{
					na = new JTextField();
					jPanel1.add(na, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
				}
				{
					nb = new JTextField();
					jPanel1.add(nb, new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
				}
				{
					jLabel3 = new JLabel();
					jPanel1.add(jLabel3, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.VERTICAL, new Insets(0, 0, 0, 0), 0, 0));
					jLabel3.setText("A");
					jLabel3.setFont(new java.awt.Font("Dialog",1,16));
				}
				{
					jLabel4 = new JLabel();
					jPanel1.add(jLabel4, new GridBagConstraints(7, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.VERTICAL, new Insets(0, 0, 0, 0), 0, 0));
					jLabel4.setText("B");
					jLabel4.setFont(new java.awt.Font("Dialog",1,16));
				}
				{
					submit = new JButton();
					jPanel1.add(submit, new GridBagConstraints(8, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
					submit.setText("Submit");
					submit.addActionListener(this);
				}
				{
					start = new JButton();
					jPanel1.add(start, new GridBagConstraints(
						8,
						0,
						1,
						1,
						0.0,
						0.0,
						GridBagConstraints.CENTER,
						GridBagConstraints.NONE,
						new Insets(0, 0, 0, 0),
						0,
						0));
					start.setText("Start");
					start.addActionListener(this);
				}
			}
			{
				jScrollPane1 = new JScrollPane();
				this.add(jScrollPane1, new GridBagConstraints(0, 1, 1, 4, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
				jScrollPane1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
				jScrollPane1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
				{
					remaining = new JTextArea();
					jScrollPane1.setViewportView(remaining);
				}
			}
			{
				jScrollPane2 = new JScrollPane();
				this.add(jScrollPane2, new GridBagConstraints(1, 0, 4, 5, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
				jScrollPane2.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
				jScrollPane2.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
				{
					history = new JTextArea();
					jScrollPane2.setViewportView(history);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void actionPerformed(ActionEvent ae)
	{
		if (ae.getSource().equals(start)) {
			history.append("=-------------------=\n");
			remaining.append("=-------------------=\n");
			initLogicData();
		} else {
			try {
				// get feedback
				int ab[] = new int[2];
				ab[0] = Integer.parseInt(na.getText());
				ab[1] = Integer.parseInt(nb.getText());
				// update record
				String s = "R" + bac.round + " " + guessNumber.getText()
						+ " " + ab[0] + "A" + ab[1] + "B\n";
				history.append(s);
				System.out.println("history pass");
				bac.userFeedback(ab);
				System.out.println("bac feedback pass");
				if (bac.guess != null)
					guessNumber.setText(arrayToString(bac.guess));
				else
					guessNumber.setText("????");
				s = "R" + bac.round + " there are " + bac.getRemainingNumbers() + " possible number(s)\n";
				remaining.append(s);
			} catch (Exception e) { // avoid parsing number exception
				e.printStackTrace();
			}
		}
	}

}
