using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

using System.Net;
using System.IO;

namespace WebDownloader
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class MainForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.TextBox url;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Button get;
		private System.Windows.Forms.RichTextBox msg_board;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem option;
		private System.Windows.Forms.MenuItem help;
		private System.Windows.Forms.MenuItem subAbout;
		private System.Windows.Forms.MenuItem subSetting;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public MainForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			if (File.Exists(ConfName)) {
				StreamReader sr = new StreamReader(ConfName);
				DefaultSavedName = sr.ReadLine();
				sr.Close();
			} else {
				DefaultSavedName = "saved.tmp";
			}
			
			this.AddOwnedForm(new Setting(this));
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.url = new System.Windows.Forms.TextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.get = new System.Windows.Forms.Button();
			this.msg_board = new System.Windows.Forms.RichTextBox();
			this.label2 = new System.Windows.Forms.Label();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.option = new System.Windows.Forms.MenuItem();
			this.subSetting = new System.Windows.Forms.MenuItem();
			this.help = new System.Windows.Forms.MenuItem();
			this.subAbout = new System.Windows.Forms.MenuItem();
			this.SuspendLayout();
			// 
			// url
			// 
			this.url.Location = new System.Drawing.Point(64, 24);
			this.url.Name = "url";
			this.url.Size = new System.Drawing.Size(448, 22);
			this.url.TabIndex = 0;
			this.url.Text = "";
			this.url.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.url_KeyPress);
			// 
			// label1
			// 
			this.label1.BackColor = System.Drawing.SystemColors.ActiveCaption;
			this.label1.Font = new System.Drawing.Font("Trebuchet MS", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.ForeColor = System.Drawing.SystemColors.ActiveCaptionText;
			this.label1.Location = new System.Drawing.Point(16, 24);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(40, 24);
			this.label1.TabIndex = 1;
			this.label1.Text = "URL";
			// 
			// get
			// 
			this.get.Location = new System.Drawing.Point(16, 64);
			this.get.Name = "get";
			this.get.Size = new System.Drawing.Size(56, 32);
			this.get.TabIndex = 2;
			this.get.Text = "Get";
			this.get.Click += new System.EventHandler(this.get_Click);
			// 
			// msg_board
			// 
			this.msg_board.BackColor = System.Drawing.Color.Black;
			this.msg_board.Font = new System.Drawing.Font("PMingLiU", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(136)));
			this.msg_board.ForeColor = System.Drawing.SystemColors.Info;
			this.msg_board.Location = new System.Drawing.Point(16, 152);
			this.msg_board.Name = "msg_board";
			this.msg_board.ReadOnly = true;
			this.msg_board.Size = new System.Drawing.Size(504, 144);
			this.msg_board.TabIndex = 3;
			this.msg_board.Text = "";
			// 
			// label2
			// 
			this.label2.BackColor = System.Drawing.SystemColors.Highlight;
			this.label2.Font = new System.Drawing.Font("Tahoma", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label2.ForeColor = System.Drawing.SystemColors.ControlLight;
			this.label2.Location = new System.Drawing.Point(16, 120);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(96, 24);
			this.label2.TabIndex = 4;
			this.label2.Text = "Message";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.option,
																					  this.help});
			// 
			// option
			// 
			this.option.Index = 0;
			this.option.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																				   this.subSetting});
			this.option.Text = "Option(&O)";
			// 
			// subSetting
			// 
			this.subSetting.Index = 0;
			this.subSetting.Text = "Setting(S)";
			this.subSetting.Click += new System.EventHandler(this.subSetting_Click);
			// 
			// help
			// 
			this.help.Index = 1;
			this.help.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																				 this.subAbout});
			this.help.Text = "Help(&H)";
			// 
			// subAbout
			// 
			this.subAbout.Index = 0;
			this.subAbout.Text = "About(&A)";
			this.subAbout.Click += new System.EventHandler(this.subAbout_Click);
			// 
			// MainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 15);
			this.ClientSize = new System.Drawing.Size(536, 310);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.msg_board);
			this.Controls.Add(this.get);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.url);
			this.Menu = this.mainMenu1;
			this.Name = "MainForm";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "WebDownloader v0.1";
			this.ResumeLayout(false);

		}
		#endregion		

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new MainForm());
		}
		
		string default_saved_name;
		public string DefaultSavedName
		{
			set { default_saved_name = value; }
			get { return default_saved_name; }
		}
		
		public string ConfName
		{
			get { return "tinyWD.conf"; }
		}

		private void get_Click(object sender, System.EventArgs e)
		{
			WebClient wc = new WebClient ();

			bool bFailed = false;
			string file_name = "";
			string s = url.Text;
			string head = "http://";
			if (s.IndexOf(head) < 0)
				s = head + s;
			int n = s.LastIndexOf("/");
			if (n < 0) {
				bFailed = true;
			} else {
				string t = s.Substring(n);
				file_name = t.Substring(1);
				if (file_name == null || file_name == "" || file_name.IndexOf("?") >= 0)
					bFailed = true;
			}
			if (bFailed)		
				file_name = DefaultSavedName;
				
			msg_board.Text = "";
			try {
				wc.DownloadFile(s, file_name);
				msg_board.Text = "Succeed!" + " Save as '" + file_name + "'";
			} catch (WebException we) {
				string exception = we.ToString();
				if (we.InnerException != null)
					exception = we.InnerException.Message;
				msg_board.Text = "ERROR: " + exception; // + " : " + file_name;
			}			
		}

		private void url_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			//msg_board.Text = "e.KeyChar = " + (int)e.KeyChar;
			if (e.KeyChar == '\r')
				get_Click(sender, e);
		}

		private void subAbout_Click(object sender, System.EventArgs e)
		{
			DialogResult msg = new DialogResult();
			msg = MessageBox.Show("Tiny Web Downloader v0.1\n\n\nwritten by fcamel\nhttp://www.csie.nctu.edu.tw/~chlo/", 
								"Tiny Web Downloader v0.1", 
								MessageBoxButtons.OK, 
								MessageBoxIcon.Information);
			
		}

		private void subSetting_Click(object sender, System.EventArgs e)
		{
			Form setting = this.OwnedForms[0];
			setting.Show();			
		}

	}
}
