import java.lang.*;
import java.io.*;
import java.util.*;

class Comp
{
	public static int max(int a, int b)
	{
		return a > b ? a : b;
	}

	public static int min(int a, int b)
	{
		return a < b ? a : b;
	}
	
	public static int abs(int n)
	{
		return n >= 0 ? n : -n;
	}
}

public class Bignum
{
	private static int maxlen = 1;// default length
	private int num[] = null;	// data
	private int len;		// len:length of num used
	private boolean minus;		// true if minus


	/** positive <-> negative */
	void ChangeSign()
	{
		if (minus == true)
			minus = false;
		else
			minus = true;
	}
	/** delete pre 0s and check if -0 existed */
	private void check()
	{
		int i;

		for (i=len-1; i>0; i--)
			if (num[i] > 0)
				break;
		len = i + 1;
		if (len == 1 && num[i] == 0)
			minus = false;
	}

	public Bignum(String s)
	{
		this(s, maxlen);
	}

	public Bignum(String s, int nbyte)
	{
		int i, slen;

		len = Comp.max(s.length(), nbyte);
		num = new int[len];
		/* atoi */
		len = slen = s.length();
		i = 0;
		minus = false;
		if (s.charAt(0) == '-') {
			minus = true;
			len--;
			i++;
		}
		for (; i<slen; i++)
			num[slen-1-i] = s.charAt(i) - '0';

		check();
	}

	public Bignum myclone()
	{
		Bignum c;

		c = new Bignum("0", len);
		c.num = (int[]) num.clone();
		c.len = len;
		c.minus = minus;

		return c;
	}

	public static void SetMaxLen(int len)
	{
		maxlen = len;
	}

	private static int CompWithoutSign(int na[], int nalen, int nb[], int nblen)
	{
		int i, len;

		if (nalen < nblen)
			return -1;
		else if (nalen > nblen)
			return 1;
		for (i=nalen-1; i>=0; i--) {
			if (na[i] < nb[i])
				return -1;
			else if (na[i] > nb[i])
				return 1;
		}
		return 0;
	}

	public static int compareWithoutSign(Bignum a, Bignum b)
	{
		return CompWithoutSign(a.num, a.len, b.num, b.len);
	}

	public static int compare(Bignum a, Bignum b)
	{
		if (a.minus == false && b.minus == true)
			return 1;
		else if (a.minus == true && b.minus == false)
			return -1;
		else if (a.minus == true && b.minus == true)
			return -1 * CompWithoutSign(a.num, a.len, b.num, b.len);
		else
			return CompWithoutSign(a.num, a.len, b.num, b.len);
	}

	/** [note] no error detecting */
	private static void overadd(int num[], int site)
	{
		int i;

		for (i=site; i<num.length; i++)
			if (num[i] >= 10) {
				num[i+1] += num[i] / 10;
				num[i] %= 10;
			} else {
				break;
			}
	}

	/** ɦ: from "site"; return the "numlen" */
	/** [note] no error detecting */
	private static int oversub(int num[], int numlen, int site)
	{
		int i;

		for (i=site; i<numlen; i++) {
			if (num[i] == 0) {
				num[i] = 9;
			} else {
				num[i]--;
				break;
			}
		}
		return num[numlen-1]==0 ? numlen-1 : numlen;
	}

	public static Bignum sub(Bignum aa, Bignum bb)
	{
		Bignum c, a, b;
		int big[], small[];
		int blen, slen;		// big length, small length
		int i, comp;

		a = aa.myclone();
		b = bb.myclone();
		c = new Bignum("0", Comp.max(aa.len, bb.len)+2);
		if (a.minus == true && b.minus == false) {
			b.minus = true;
			c = add(a, b);
			return c;
		} else if (a.minus == false && b.minus == true) {
			b.minus = false;
			c = add(a, b);
			return c;
		}
		
		comp = compare(a, b);
		if (comp == 0)
			return c;
		comp = CompWithoutSign(a.num, a.len, b.num, b.len);
		/** default : comp greater than 0 */
		big = a.num;
		blen = a.len;
		small = b.num;
		slen = b.len;
		c.minus = a.minus==true ? true : false;
		if (comp < 0) {
			big = b.num;
			blen = b.len;
			small = a.num;
			slen = a.len;
			c.minus = a.minus==false ? true : false;
		}
		for (i=0; i<slen; i++) {
			c.num[i] = big[i] - small[i];
			if (c.num[i] < 0) {
				c.num[i] += 10;
				blen = oversub(big, blen, i+1);
			}
		}
		for (; i<blen; i++)
			c.num[i] = big[i];
		for (i--; i>0 && c.num[i]==0; i--)
			;
		c.len = i+1;

		c.check();
		return c;
	}

	public static Bignum add(Bignum aa, Bignum bb)
	{
		Bignum c, a, b;
		int i, len, more;
		int num[] = null;

		a = aa.myclone();
		b = bb.myclone();
		c = new Bignum("0", Comp.max(aa.len, bb.len)+2);
		if (a.minus == true && b.minus == true) {
			c.minus = true;
		} else if (a.minus == false && b.minus == false) {
			c.minus = false;
		} else {
			if (b.minus == true) {
				b.minus = false;
				c = sub(a, b);
			} else {
				a.minus = false;
				c = sub(b, a);
			}
			return c;
		}
		
		len = Comp.min(a.len, b.len);
		for (more=i=0; i<len; i++) {
			c.num[i] = a.num[i] + b.num[i] + more;
			more = 0;
			if (c.num[i] >= 10) {
				more = 1;
				c.num[i] %= 10;
			}
		}
		len = Comp.max(a.len, b.len);
		if (a.len > b.len)
			num = a.num;
		else
			num = b.num;
		for (; i<len; i++) {
			c.num[i] = num[i] + more;
			more = 0;
			if (c.num[i] >= 10) {
				more = 1;
				c.num[i] %= 10;
			}
		}
		if (more > 0) {
			c.num[i] = more;
			c.len = i + 1;
		} else
			c.len = i;

		c.check();
		return c;
	}

	public static Bignum mul(Bignum aa, Bignum bb)
	{
		Bignum c, a, b;
		int i, j, more;
		int num[] = null;

		a = aa.myclone();
		b = bb.myclone();
		c = new Bignum("0", aa.len+bb.len+2);
		Arrays.fill(c.num, 0);
		if ((a.minus==true && b.minus==true) || (a.minus==false && b.minus==false))
			c.minus = false;
		else
			c.minus = true;

		for (i=0; i<a.len; i++) {
			for (j=0; j<b.len; j++) {
				c.num[i+j] += a.num[i]*b.num[j];
				if (c.num[i+j] >= 10) {
					c.num[i+j+1] += c.num[i+j] / 10;
					overadd(c.num, i+j+1);
					c.num[i+j] %= 10;
				}
			}
		}
		//c.len = maxlen;
		c.len = c.num.length;

		c.check();
		return c;
	}

	private static void shift(Bignum a, int way)
	{
		int i;

		if (way > 0) {			 /** right shift */
			//System.out.println("shift: a.len=" + a.len + " a.num=" + a.num.length);
			int tnum[] = new int[a.len+1];
			for (i=a.len; i>0; i--)
				tnum[i] = a.num[i-1];
			tnum[0] = 0;
			a.num = tnum;
			a.len++;
		} else { 			/** left shift */
			for (i=0; i<a.len-1; i++)
				a.num[i] = a.num[i+1];
			a.len--;
		}
	}

	/** a = bq + r:  return Bignum[0]=q ;  Bignum[1]=r */
	public static Bignum[] div(Bignum aa, Bignum bb)
	{
		Bignum a, b;
		Bignum c[] = new Bignum[2];
		int i, j;
		boolean minus_a, minus_b;

		minus_a = aa.minus;
		minus_b = bb.minus;

		a = aa.myclone();
		b = bb.myclone();
		a.minus = b.minus = false;
		c[0] = new Bignum("0", Comp.max(aa.len, bb.len));
		c[1] = new Bignum("0", Comp.max(aa.len, bb.len));

		i = 0;
		while (compare(a, b) >= 0) {
			shift(b, 1);
			if (compare(a, b) < 0) {
				shift(b, -1);
				break;
			}
			i++;
		}
		while (compare(a, b) >= 0) {
			for (j=0; compare(a, b) >= 0; j++)
				a = sub(a, b);
			c[0].num[i] = j;
			while (i>0 && compare(a, b)<0) {
				shift(b, -1);
				i--;
			}
		}

		c[0].len = c[0].num.length; //maxlen;
		c[0].minus = minus_a ^ minus_b;
		c[0].check();
		c[1] = a;
		c[1].minus = minus_a ^ minus_b;
		c[1].check();
		return c;
	}

	public String toString()
	{
		int i;
		String t = "";

		if (minus == true)
			t += "-";
		/** truncate the head zeros */
		for (i=len-1; i>0; i--)
			if (num[i] > 0)
				break;
		for (; i>=0; i--)
			t += Integer.toString(num[i]);
		return t;
	}

	public void output()
	{
		int i;

		if (minus == true)
			System.out.print("-");
		/** truncate the head zeros */
		for (i=len-1; i>0; i--)
			if (num[i] > 0)
				break;
		for (; i>=0; i--)
			System.out.print(num[i]);
		System.out.println();
	}
}
