import java.lang.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;

public class Cal extends JPanel implements Action//, KeyListener
{
	/*
	 * GUI
	 */
	JButton d[];
	JButton dot, bs;	// bs: backspace		dot: unuse now
	JButton add, sub, mul, div, mod;
	JButton sign, eq, ce, ac;
	JButton ma, ms, mr, mc; // M+ M- MR MC;

	JButton guiL, guiR;

	JTextField txt;

	JLabel mem;
	/*
	 * data
	 */
	Bignum tnum, ans, memans;
	String top;
	boolean memory;
	boolean inDigits;
	boolean init;
	final int NUM=0, OP=1, EQ=2, MR=3;
	int state;

	private void sendActionEvent(JButton b)
	{
		actionPerformed(new ActionEvent(b, ActionEvent.ACTION_PERFORMED, b.getActionCommand()));
	}

	public void keyPressed(KeyEvent e) {}
	public void keyReleased(KeyEvent e) {}
	public void keyTyped(KeyEvent e)
	{
		char key = e.getKeyChar();
		System.out.println("key event: " + key);
		if (key >= '0' && key <= '9')
			sendActionEvent(d[key-'0']);
	}

	private void calculate()
	{
		if (top.equals("+"))
			ans = Bignum.add(ans, tnum);
		else if (top.equals("-"))
			ans = Bignum.sub(ans, tnum);
		else if (top.equals("*"))
			ans = Bignum.mul(ans, tnum);
		else if (top.equals("/") || top.equals("%")) {
			System.out.println("calculate: " + top);
			if (Bignum.compareWithoutSign(tnum, new Bignum("0")) == 0) {
				txt.setText("error: divide 0");
				return ;
			}
			Bignum t[] = Bignum.div(ans, tnum);
			ans = top.equals("/") ? t[0] : t[1];
		}

		txt.setText(ans.toString());
	}

	public void actionPerformed(ActionEvent e)
	{
		//JButton b = null;
		boolean isSetText = false;
		int i;

		System.out.println("actionCommand: " + e.getActionCommand());
		/*
		if (e.getSource() instanceof JButton)
			b = (JButton)e.getSource();
		else {
			System.out.println("not JButton: " + e);
			System.out.println("\n" + e.getSource().getClass());
			return;
		}
		*/
		String b = e.getActionCommand();
		for (i=0; i<10; i++) {
			if (b.equals(d[i].getActionCommand())) {
				if (inDigits)
					tnum = Bignum.add( Bignum.mul(tnum, new Bignum("10")), new Bignum(b));
				else
					tnum = new Bignum(b);
				txt.setText(tnum.toString());
				isSetText = true;

				if (init) {
					ans = tnum.myclone();
					top = "";
				}

				inDigits = true;
				state = NUM;
			}
		}
		if ( b.equals(add.getActionCommand()) 
			|| b.equals(sub.getActionCommand())
			|| b.equals(mul.getActionCommand())
			|| b.equals(div.getActionCommand())
			|| b.equals(mod.getActionCommand()) ) {
			System.out.println("op " + b + " top " + top);
			if (top != "" && init == false && (state == NUM || state == MR)) { // calculate it !!
				System.out.println("calculate");
				calculate();
				isSetText = true;
			}
			top = b;

			inDigits = false;
			init = false;
			state = OP;
		} else if (b.equals(sign.getActionCommand())) {
			if (state == NUM) {
				tnum = Bignum.mul(tnum, new Bignum("-1"));
				if (init)
					ans = tnum.myclone();
				txt.setText(tnum.toString());
				isSetText = true;
			} else if (state == EQ) {
				ans = Bignum.mul(ans, new Bignum("-1"));
				txt.setText(ans.toString());
				isSetText = true;
			}
		} else if (b.equals(eq.getActionCommand()) || b.charAt(0)=='\n') {
			if (top != "") { // calculate it !!
				calculate();
				isSetText = true;
			}

			inDigits = false;
			init = true;
			state = EQ;
		} else if (b.equals(ce.getActionCommand())) {
			if (state == NUM)
				tnum = new Bignum("0");
			txt.setText("0");
		} else if (b.equals(ac.getActionCommand()) || b.charAt(0) == '\033') {
			ans = new Bignum("0");
			tnum = new Bignum("0");
			top = "";
			txt.setText("0");
		} else if (b.equals(bs.getActionCommand()) || b.charAt(0) == '\b') {
			if (state == NUM) {
				Bignum tc[] = new Bignum[2];
				tc = Bignum.div(tnum, new Bignum("10"));
				tnum = tc[0];
				if (init)
					ans = tnum.myclone();
				txt.setText(tnum.toString());
				isSetText = true;
			}
		} else if (b.equals(ma.getActionCommand())) {
			boolean flag = false;
			if (state == NUM) {
				memans = Bignum.add(memans, tnum);
				flag = true;
			} else if (state == EQ) {
				memans = Bignum.add(memans, ans);
				flag = true;
			} else if (state == MR) {
				memans = Bignum.add(memans, memans);
				flag = true;
			}
			if (flag) {
				memory = true;
				mem.setText("memory");
			}

			inDigits = false;
		} else if (b.equals(ms.getActionCommand())) {
			boolean flag = false;
			if (state == NUM) {
				memans = Bignum.sub(memans, tnum);
				flag = true;
			} else if (state == EQ) {
				memans = Bignum.sub(memans, ans);
				flag = true;
			} else if (state == MR) {
				memans = Bignum.sub(memans, memans);
				flag = true;
			}
			if (flag) {
				memory = true;
				mem.setText("memory");
			}

			inDigits = false;
		} else if (b.equals(mr.getActionCommand())) {
			if (state == NUM || state == OP)
				tnum = memans.myclone();
			txt.setText(memans.toString());
			isSetText = true;

			state = MR;
			inDigits = false;
		} else if (b.equals(mc.getActionCommand())) {
			memans = new Bignum("0");
			memory = false;
			mem.setText("");
			
			inDigits = false;
		} else if (b.equals(guiL.getActionCommand())) {
			guiL.doClick();
		} else if (b.equals(guiR.getActionCommand())) {
			guiR.doClick();
		}
		// use EXPONENT to express if the ans is too big to see
		if (isSetText && txt.getText().length() > 100) {
			String t = txt.getText();
			if (t.substring(0, 1).equals("-") && t.length() > (100+1))
				txt.setText(t.substring(0, 2) + "." + t.substring(2, 100+1) + "E+" + (t.length()-2));
			else
				txt.setText(t.substring(0, 1) + "." + t.substring(1, 100) + "E+" + (t.length()-1));
		}
	}

	public void addPropertyChangeListener(PropertyChangeListener listener) {}
	public Object getValue(String key) { return null; }
	public boolean isEnabled() { return true; }
	public void putValue(String key, Object value) {}
	public void removePropertyChangeListener(PropertyChangeListener listener) {}
	public void setEnabled(boolean b) {}


	private void addGB(Component obj, int x, int y)
	{
		addGB(obj, x, y, 1, 1);
	}

	private void addGB(Component obj, int x, int y, int w, int h)
	{
		GridBagConstraints con = new GridBagConstraints();
		con.weightx = con.weighty = 0.05;
		con.fill = GridBagConstraints.BOTH;
		con.gridx = x;
		con.gridy = y;
		con.gridheight = h;
		con.gridwidth = w;
		add(obj, con);
	}

	public Cal(JTextField t, JButton _guiL, JButton _guiR)
	{
		txt = t; txt.setText("0");
		guiL = _guiL;
		guiR = _guiR;
		int i;

		//addKeyListener(this);
		setLayout(new GridBagLayout());
		/*
		 * GUI
		*/ 
		// new
		d = new JButton[10];
		for (i=0; i<10; i++) {
			d[i] = new JButton(Integer.toString(i));
			d[i].addActionListener(this);
		}
		dot = new JButton("."); dot.addActionListener(this);
		bs = new JButton("Backspace"); bs.addActionListener(this);
		add = new JButton("+"); add.addActionListener(this);
		sub = new JButton("-"); sub.addActionListener(this);
		mul = new JButton("*"); mul.addActionListener(this);
		div = new JButton("/"); div.addActionListener(this);
		mod = new JButton("mod"); mod.addActionListener(this); mod.setActionCommand("%");
		sign = new JButton("+/-"); sign.addActionListener(this);
		eq = new JButton("="); eq.addActionListener(this);
		ce = new JButton("CE"); ce.addActionListener(this); ce.setActionCommand("c");
		ac = new JButton("AC"); ac.addActionListener(this);
		ma = new JButton("M+"); ma.addActionListener(this);
		ms = new JButton("M-"); ms.addActionListener(this);
		mr = new JButton("MR"); mr.addActionListener(this);
		mc = new JButton("MC"); mc.addActionListener(this);

		mem = new JLabel("", JLabel.CENTER);
		// add
		addGB(d[7], 0, 0);
		addGB(d[8], 1, 0);
		addGB(d[9], 2, 0);
		addGB(d[4], 0, 1);
		addGB(d[5], 1, 1);
		addGB(d[6], 2, 1);
		addGB(d[1], 0, 2);
		addGB(d[2], 1, 2);
		addGB(d[3], 2, 2);
		addGB(d[0], 0, 3, 2, 1);
		addGB(dot, 2, 3);
		addGB(bs, 3, 3, 1, 1);
		addGB(add, 3, 0);
		addGB(sub, 4, 0);
		addGB(mul, 5, 0);
		addGB(div, 6, 0);
		addGB(mod, 7, 0);
		addGB(sign, 3, 1);
		addGB(eq, 4, 1, 2, 1);
		addGB(ce, 6, 1);
		addGB(ac, 7, 1);
		addGB(ma, 3, 2);
		addGB(ms, 4, 2);
		addGB(mr, 5, 2, 2, 1);
		addGB(mc, 7, 2);

		addGB(guiL, 4, 3);
		addGB(guiR, 5, 3);

		addGB(mem, 6, 3, 2, 1);
		/*
		 * data
		 */
		tnum = new Bignum("0");
		top = "";
		ans = new Bignum("0");
		memans = new Bignum("0");
		memory = false;
		inDigits = false;
		init = true;
		state = NUM;

		/*
		 * Key Event
		 */
		InputMap im = getInputMap(WHEN_IN_FOCUSED_WINDOW);
		ActionMap am = getActionMap();
		for (i=0; i<10; i++) {
			im.put(KeyStroke.getKeyStroke((char)('0'+i)), ""+i);
			am.put(""+i, this);
		}
		im.put(KeyStroke.getKeyStroke('+'), "+");
		am.put("+", this);
		im.put(KeyStroke.getKeyStroke('-'), "-");
		am.put("-", this);
		im.put(KeyStroke.getKeyStroke('*'), "*");
		am.put("*", this);
		im.put(KeyStroke.getKeyStroke('/'), "/");
		am.put("/", this);
		im.put(KeyStroke.getKeyStroke('%'), "mod");
		am.put("mod", this);
		im.put(KeyStroke.getKeyStroke('='), "=");
		am.put("=", this);
		im.put(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0), "enter");
		am.put("enter", this);
		im.put(KeyStroke.getKeyStroke(KeyEvent.VK_BACK_SPACE, 0), "bs");
		am.put("bs", this);
		im.put(KeyStroke.getKeyStroke('c'), "ce");
		am.put("ce", this);
		im.put(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), "ac");
		am.put("ac", this);
		im.put(KeyStroke.getKeyStroke('<'), "<");
		am.put("<", this);
		im.put(KeyStroke.getKeyStroke('>'), ">");
		am.put(">", this);


		eq.grabFocus();
		bs.grabFocus();
	}
}
